/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.service.DocResolver;
import com.erinors.tapestry.tapdoc.service.FileNameGenerator;
import com.erinors.tapestry.tapdoc.service.TapdocContext;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

public class DocResolverImpl
implements DocResolver {
    private final TapdocContext context;
    private final FileNameGenerator fileNameGenerator;
    private boolean initialized;
    private Map<String, String> javadocByPackage = new HashMap<String, String>();

    public DocResolverImpl(TapdocContext context, FileNameGenerator fileNameGenerator) {
        this.context = context;
        this.fileNameGenerator = fileNameGenerator;
    }

    private void initialize() {
        if (!this.initialized) {
            if (this.context.getJavadocLinks() != null) {
                for (String url : this.context.getJavadocLinks()) {
                    if (!url.endsWith("/")) {
                        url = url + "/";
                    }
                    StringWriter writer = new StringWriter();
                    try {
                        IOUtils.copy((InputStream)new URL(url + "package-list").openStream(), (Writer)writer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    StringTokenizer tokenizer2 = new StringTokenizer(writer.toString());
                    while (tokenizer2.hasMoreTokens()) {
                        this.javadocByPackage.put(tokenizer2.nextToken(), url);
                    }
                }
            }
            this.initialized = true;
        }
    }

    public String getJavadocUrl(String type, String member) {
        this.initialize();
        String javadocUrl = null;
        if (type != null && type.length() > 0) {
            String packageName;
            if (type.endsWith("[]")) {
                type = type.substring(0, type.length() - 2);
            }
            String string = packageName = type.indexOf(46) != -1 ? type.substring(0, type.lastIndexOf(46)) : "";
            if (this.javadocByPackage.containsKey(packageName)) {
                javadocUrl = this.javadocByPackage.get(packageName) + type.replace('.', '/') + ".html";
            }
            if (javadocUrl != null && member != null && member.length() > 0) {
                javadocUrl = javadocUrl + "#" + member;
            }
        }
        return javadocUrl;
    }

    public String getLibraryUrl(String libraryLocation) {
        this.initialize();
        if (this.context.getLibraryLocations().contains(libraryLocation)) {
            return this.fileNameGenerator.getLibraryDirectory(libraryLocation);
        }
        return null;
    }

    public String getComponentUrl(String libraryLocation, String componentName) {
        this.initialize();
        if (this.context.getLibraryLocations().contains(libraryLocation)) {
            return this.fileNameGenerator.getComponentIndexFile(libraryLocation, componentName, false);
        }
        return null;
    }
}

