/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc;

import com.erinors.tapestry.tapdoc.util.TapdocPrefs;
import com.erinors.tapestry.tapdoc.util.TapdocUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.impl.RegistryBuilder;
import org.apache.tools.ant.Task;

public class TapDocTask
extends Task {
    private ClassResolver classResolver = new DefaultClassResolver(RegistryBuilder.class.getClassLoader());
    private File outputDirectory;
    private File generatedOutputDirectory;
    private List<String> libraryLocations;
    private List<String> javadocLinks;
    private String fileSystemId = "file";
    private File javaDomFile;
    private List<String> tapdocLinks;

    public static void main(String[] args) {
        if (args.length < 2) {
            TapDocTask.printUsage();
        } else {
            TapDocTask tapDoc = new TapDocTask();
            tapDoc.setOutputDirectory(new File(args[0]));
            tapDoc.setGeneratedOutputDirectory(new File(args[0]));
            tapDoc.setLibraries(args[1]);
            if (args.length > 2) {
                tapDoc.setJavadocLinks(args[2]);
            }
            tapDoc.execute();
        }
    }

    private static void printUsage() {
        System.out.println("arguments: (output directory) (library locations separated by comma) [javadoc root links separated by comma]");
    }

    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public void setOutputDirectory(File outputDirectory) {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdir();
        } else if (!outputDirectory.isDirectory()) {
            throw new RuntimeException("Invalid output directory: must be a directory not a normal file");
        }
        this.outputDirectory = outputDirectory;
    }

    public void setGeneratedOutputDirectory(File generatedOutputDirectory) {
        if (!generatedOutputDirectory.exists()) {
            generatedOutputDirectory.mkdir();
        } else if (!generatedOutputDirectory.isDirectory()) {
            throw new RuntimeException("Invalid output directory: must be a directory not a normal file");
        }
        this.generatedOutputDirectory = generatedOutputDirectory;
    }

    public void setLibraries(String libraries) {
        if (libraries == null || libraries.length() == 0) {
            throw new ApplicationRuntimeException("Invalid library locations: " + libraries);
        }
        this.libraryLocations = Arrays.asList(libraries.split(","));
    }

    public void setJavadocLinks(String javadocLinks) {
        if (javadocLinks.trim().startsWith("-link")) {
            StringBuilder buffer = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(javadocLinks, "-link");
            while (tokenizer.hasMoreTokens()) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(tokenizer.nextToken().trim());
            }
            javadocLinks = buffer.toString();
        }
        this.javadocLinks = Arrays.asList(javadocLinks.split(","));
    }

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public void setJavaDomFile(File javaDomFile) {
        this.javaDomFile = javaDomFile;
    }

    public void setTapdocLinks(String tapdocLinks) {
        this.tapdocLinks = null;
    }

    public void execute() {
        if (this.outputDirectory == null) {
            throw new ApplicationRuntimeException("The output directory should be defined in parameter 'outputDirectory'.");
        }
        if (this.libraryLocations == null) {
            throw new ApplicationRuntimeException("Library locations should be defined in parameter 'libraries'.");
        }
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileObject outputDirectoryFileObject = fsManager.resolveFile(this.fileSystemId + "://" + this.outputDirectory.getAbsolutePath());
            FileObject generatedOutputDirectoryFileObject = fsManager.resolveFile(this.fileSystemId + "://" + this.generatedOutputDirectory.getAbsolutePath());
            FileObject javaDomFileObject = this.javaDomFile != null ? fsManager.resolveFile(this.fileSystemId + "://" + this.javaDomFile.getAbsolutePath()) : null;
            TapdocPrefs prefs = new TapdocPrefs(true, true);
            prefs.setLibraryLocations(this.libraryLocations);
            prefs.setJavadocLinks(this.javadocLinks);
            prefs.setTapdocLinks(this.tapdocLinks);
            TapdocUtils.generate(this.classResolver, outputDirectoryFileObject, generatedOutputDirectoryFileObject, javaDomFileObject, prefs);
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }
}

