//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.tapestry.IMarkupWriter;

/**
 * @author Norbert Sándor
 */
public class XmlElement implements XmlPart
{
    public XmlElement()
    {
    }

    public XmlElement(String name)
    {
        setName(name);
    }

    public XmlElement(String name, String... attributes)
    {
        this(name);

        assert attributes.length % 2 == 0;
        for (int i = 0; i < attributes.length; i += 2)
        {
            addAttribute(attributes[i], attributes[i + 1]);
        }
    }

    private String name;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    private Map<String, String> attributes = new HashMap<String, String>();

    public Map<String, String> getAttributes()
    {
        return attributes;
    }

    public String getAttribute(String name)
    {
        return getAttributes().get(name);
    }

    public void addAttribute(String name, String value)
    {
        attributes.put(name, value);
    }

    private List<XmlPart> body = new ArrayList<XmlPart>();

    public List<XmlPart> getBody()
    {
        return Collections.unmodifiableList(body);
    }

    public void add(XmlPart part)
    {
        if (part != null)
        {
            body.add(part);
        }
    }

    public void toXml(IMarkupWriter out)
    {
        if (getBody().size() == 0)
        {
            out.beginEmpty(getName());
        }
        else
        {
            out.begin(getName());
        }

        for (Map.Entry<String, String> attribute : getAttributes().entrySet())
        {
            out.attribute(attribute.getKey(), attribute.getValue());
        }

        if (getBody().size() > 0)
        {
            for (XmlPart part : getBody())
            {
                part.toXml(out);
            }

            out.end();
        }
    }
}
