package com.erinors.tapestry.tapdoc.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import org.apache.commons.vfs.FileObject;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Registry;
import org.apache.hivemind.impl.RegistryBuilder;
import org.apache.hivemind.impl.XmlModuleDescriptorProvider;
import org.apache.tapestry.services.ApplicationInitializer;

import com.erinors.tapestry.tapdoc.mock.MockServlet;
import com.erinors.tapestry.tapdoc.service.Generator;

public class TapdocUtils
{
    private static final List<String> DefaultJavadocLinks = Arrays.asList("http://java.sun.com/javase/6/docs/api/",
            "http://java.sun.com/javaee/5/docs/api/",
            "http://tapestry.apache.org/tapestry4.1/tapestry-framework/apidocs/");

    public static void generate(ClassResolver classResolver, FileObject outputDirectory,
            FileObject generatedOutputDirectory, FileObject javaDom, TapdocPrefs prefs)
    {
        if (prefs.getJavadocLinks() == null)
        {
            prefs.setJavadocLinks(DefaultJavadocLinks);
        }

        // TODO allow exactly 1 .application file
        String applicationSpecificationPath = null;
        for (String libraryLocation : prefs.getLibraryLocations())
        {
            if (libraryLocation.endsWith(".application"))
            {
                applicationSpecificationPath = libraryLocation;
                break;
            }
        }

        //
        // Build registry
        //
        Thread.currentThread().setContextClassLoader(classResolver.getClassLoader());

        RegistryBuilder builder = prefs.isShowErrors() ?
                new RegistryBuilder() :
                new RegistryBuilder(new SimpleErrorHandler());
        builder.addModuleDescriptorProvider(new XmlModuleDescriptorProvider(classResolver));

        Registry registry = builder.constructRegistry(Locale.getDefault());

        try
        {
            registry.setupThread();

            try
            {
                // Initialize Tapestry

                ApplicationInitializer ai = (ApplicationInitializer) registry.getService(
                        "tapestry.init.MasterInitializer", ApplicationInitializer.class);
                ai.initialize(new MockServlet(applicationSpecificationPath));

                // Generate documentation

                ((Generator) registry.getService(Generator.class)).generate(registry, outputDirectory,
                        generatedOutputDirectory, javaDom, prefs);
            }
            finally
            {
                registry.cleanupThread();
            }
        }
        finally
        {
            registry.shutdown();
        }
    }
}
