package com.erinors.tapestry.tapdoc.test;

import junit.framework.TestCase;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.impl.RegistryBuilder;

import com.erinors.tapestry.tapdoc.service.TapdocContext;
import com.erinors.tapestry.tapdoc.service.TapdocContextImpl;

public class TapdocTestCase extends TestCase
{
    protected ClassResolver classResolver = new DefaultClassResolver(RegistryBuilder.class.getClassLoader());

    protected TapdocContext context;

    @Override
    protected void setUp() throws Exception
    {
        super.setUp();

        context = new TapdocContextImpl(null, null, null, null, getOutputDirectory(), null, null);
    }

    protected FileObject getOutputDirectory()
    {
        FileObject outputDirectory;
        try
        {
            FileSystemManager fsManager = VFS.getManager();
            outputDirectory = fsManager.resolveFile(getOutputDirectoryPath());
        }
        catch (FileSystemException e)
        {
            throw new RuntimeException(e);
        }

        return outputDirectory;
    }

    protected String getOutputDirectoryPath()
    {
        return "ram://output";
    }
}
