<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) Erinors 2006. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" doctype-system="http://maven.apache.org/dtd/xdoc_1_0.dtd"
		doctype-public="-//APACHE//DTD Documentation V1.2//EN" />

	<xsl:param name="libraryName" />
	<xsl:param name="componentName" />

	<xsl:template match="library[@name=$libraryName]/component[@name=$componentName]">
		<document>
			<properties>
				<title>
					TapDoc - Component
					<xsl:value-of select="$libraryName" />
					:
					<xsl:value-of select="$componentName" />
				</title>
			</properties>
			<body>
				<section>
					<xsl:attribute name="name">
						<xsl:value-of select="@name" />
						<xsl:if test="@deprecated = 'true'">
							- deprecated
						</xsl:if>
					</xsl:attribute>

					<p>
						<p>
							<xsl:call-template name="linkToClass">
								<xsl:with-param name="name" select="class/@name" />
								<xsl:with-param name="link" select="class/@url" />
							</xsl:call-template>
						</p>
						<p>
							<xsl:if
								test="count(visual) = 1 or count(nonvisual) = 1 or count(visual-or-nonvisual) = 1">
								<xsl:choose>
									<xsl:when test="count(visual) = 1">
										<xsl:choose>
											<xsl:when test="string-length(visual) &gt; 0">
												<xsl:value-of select="visual" disable-output-escaping="yes" />
											</xsl:when>
											<xsl:otherwise>
												<i>Visual component</i>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:when test="count(visual-or-nonvisual) = 1">
										<xsl:choose>
											<xsl:when test="string-length(visual-or-nonvisual) &gt; 0">
												<xsl:value-of select="visual-or-nonvisual"
													disable-output-escaping="yes" />
											</xsl:when>
											<xsl:otherwise>
												<i>Visual or non-visual component</i>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:when test="count(nonvisual) = 1">
										<i>Non-visual component</i>
									</xsl:when>
								</xsl:choose>
							</xsl:if>
						</p>
					</p>


					<xsl:if test="description">
						<subsection name="Description">
							<xsl:value-of select="description" disable-output-escaping="yes" />
						</subsection>
					</xsl:if>


					<!-- Parameters -->
					<xsl:if test="count(parameter) > 0">
						<subsection name="Parameters">
							<xsl:call-template name="RenderParametersTableHeader" />
						</subsection>
					</xsl:if>

					<!-- allow body, allow informal parameters, reserved parameters -->
					<p>
						Allow body:
						<xsl:if test="@allow-body = 'true'">
							<img src="../../resource/yes.gif" />
						</xsl:if>
						<xsl:if test="@allow-body = 'false'">
							<img src="../../resource/no.gif" />
						</xsl:if>
						(
						<xsl:choose>
							<xsl:when test="@allow-body-extension">
								<xsl:value-of select="@allow-body-extension" />
							</xsl:when>
							<xsl:when test="@allow-body = 'false'">removed</xsl:when>
							<xsl:otherwise>rendered</xsl:otherwise>
						</xsl:choose>
						)
					</p>

					<!-- allow-informal-parameters -->
					<p>
						Allow informal parameters:
						<xsl:if test="@allow-informal-parameters = 'true'">
							<img src="../../resource/yes.gif" />
						</xsl:if>
						<xsl:if test="@allow-informal-parameters = 'false'">
							<img src="../../resource/no.gif" />
						</xsl:if>
					</p>

					<!-- reserved-parameters -->
					<p>
						Reserved parameters:
						<xsl:choose>
							<xsl:when test="count(reserved-parameter) > 0">
								<xsl:for-each select="reserved-parameter">
									<xsl:if test="position() > 1">,</xsl:if>
									<xsl:value-of select="@name" />
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<strong>-</strong>
							</xsl:otherwise>
						</xsl:choose>
					</p>

					<!-- See also section -->
					<xsl:if test="see-also">
						<subsection name="See also">
							<p>
								<xsl:for-each select="see-also/component">
									<xsl:if test="position() > 1">,</xsl:if>
									<xsl:call-template name="InsertSeeAlsoComponent" />
								</xsl:for-each>
							</p>
							<p>
								<xsl:for-each select="see-also/java">
									<xsl:if test="position() > 1">,</xsl:if>
									<xsl:call-template name="InsertSeeAlsoJava" />
								</xsl:for-each>
							</p>
						</subsection>
					</xsl:if>

					<!-- html addon -->
					<xsl:if test="html-addon">
						<xsl:value-of select="html-addon" disable-output-escaping="yes" />
					</xsl:if>

				</section>
			</body>
		</document>

	</xsl:template>

	<xsl:template name="InsertSeeAlsoComponent">
		<a href="../../{@link}">
			<xsl:value-of select="@label" />
		</a>
	</xsl:template>

	<xsl:template name="InsertSeeAlsoJava">
		<a href="{@url}">
			<xsl:value-of select="@label" />
		</a>
	</xsl:template>

	<!-- Renders the header of the parameters table and applies templates to parameters. -->
	<xsl:template name="RenderParametersTableHeader">

		<table>
			<tr>
				<th>name</th>
				<th>type</th>
				<th>required</th>
				<th>default value</th>
				<th>description</th>
			</tr>
			<xsl:apply-templates select="parameter" />
		</table>

	</xsl:template>

	<!-- Renders a row of the parameters table. -->
	<xsl:template match="library[@name=$libraryName]/component[@name=$componentName]/parameter">

		<tr>

			<!-- parameter name -->
			<td>
				<xsl:value-of select="@name" />
			</td>

			<!-- parameter type -->
			<td>
				<xsl:call-template name="linkToClass">
					<xsl:with-param name="name" select="type/@name" />
					<xsl:with-param name="link" select="type/@url" />
					<xsl:with-param name="truncateLongerThan" select="number('45')" />
				</xsl:call-template>
			</td>

			<!-- required flag -->
			<td align="center">
				<xsl:if test="@required = 'true'">
					<img src="../../resource/yes.gif" />
				</xsl:if>
			</td>

			<!-- default value -->
			<td>
				<xsl:if test="0 != count(@default-value)">
						<xsl:value-of select="@default-value" disable-output-escaping="yes" />
				</xsl:if>
			</td>

			<!-- description of the parameter -->
			<td>
				<xsl:value-of select="description" disable-output-escaping="yes" />
			</td>

		</tr>

	</xsl:template>

	<xsl:template name="linkToClass">
		<xsl:param name="name" />
		<xsl:param name="link" />
		<xsl:param name="truncateLongerThan" />

		<xsl:choose>
			<xsl:when test="$link != ''">
				<a href="{$link}" title="{$name}">
					<xsl:call-template name="insertClassName">
						<xsl:with-param name="className" select="$name" />
						<xsl:with-param name="truncateLongerThan" select="$truncateLongerThan" />
					</xsl:call-template>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="insertClassName">
					<xsl:with-param name="className" select="$name" />
					<xsl:with-param name="truncateLongerThan" select="$truncateLongerThan" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="insertClassName">
		<xsl:param name="className" /><!-- class name -->
		<xsl:param name="truncateLongerThan" select="number('1000')" /><!-- truncate class names which are longer than this value -->

		<xsl:choose>
			<xsl:when test="string-length($className) &gt; number($truncateLongerThan)">...<xsl:value-of select="substring($className, string-length($className) - number($truncateLongerThan) + 1)" /></xsl:when>
			<xsl:otherwise><xsl:value-of select="$className" /></xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<xsl:template match="library/description" />

	<xsl:template match="library[@name = $libraryName]/component[@name != $componentName]" />
	<xsl:template match="library[@name != $libraryName]/component" />

</xsl:stylesheet>
