<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) Erinors 2006. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:output method="html"/>

	<xsl:template match="tapdoc">
		
		<html>
			<head>
				<title>TapDoc - Overview</title>
				<META NAME="Generator" CONTENT="TapDoc 1.0 - http://www.erinors.com/" />
				<link href="resource/ComponentReference.css" rel="stylesheet"
					type="text/css"/>
			</head>
			<body>
				<xsl:apply-templates select="library" />
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="library">
	
		<!-- Display library name -->
		<span class="LibraryName">
			<xsl:value-of select="@name"/>
		</span>
		
		<p>
			<xsl:value-of select="description"/>
		</p>
		
		<!-- Links to components of the library. -->
		<table border="0">
			<xsl:apply-templates select="component[(position()-1) mod 5 = 0]" />
		</table>
		
		<xsl:if test="0 != count(following-sibling::library)">
			<hr/>
		</xsl:if>
			
	</xsl:template>
	
	<!--***********************************************************************
		Generates output for a component of the currently processed library.
	-->	
	<xsl:template match="component">
		
		<tr>
			<xsl:call-template name="renderComponentCell" />
			
			<xsl:for-each select="following-sibling::component[position() &lt; 5]">
				<xsl:sort select="@name" />
				<xsl:call-template name="renderComponentCell" />
			</xsl:for-each>
		</tr>
		
	</xsl:template>

	<!--***********************************************************************
		Renders the table cell of a component containing a link to the component's reference.
	-->	
	<xsl:template name="renderComponentCell">
		<td width="100" class="LibraryComponentCell">
			<a href="{@link}" title="{description}">
				<xsl:if test="@deprecated = 'true'">
					<span style="text-decoration:line-through;" title="deprecated">
						<xsl:value-of select="@name"/>
					</span>
				</xsl:if>
				<xsl:if test="@deprecated = 'false'">
					<xsl:value-of select="@name"/>
				</xsl:if>
			</a>
		</td>
	</xsl:template>
	
</xsl:stylesheet>
