<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) Erinors 2006. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:output method="html"/>

	<xsl:template match="tapdoc">
		
		<html>
			<head>
				<title>index TODO</title>
				<META NAME="Generator" CONTENT="TapDoc 1.0 - http://www.erinors.com/" />
				<link href="resource/ComponentReference.css" rel="stylesheet"
					type="text/css"/>
			</head>
			<body>

				<xsl:for-each select="library/component">
					<xsl:sort select="@name" />
					<div>
					<a href="{@link}" title="{description}" target="content">
						<xsl:if test="@deprecated = 'true'">
							<span style="text-decoration:line-through;" title="deprecated">
								<xsl:value-of select="@name"/>
							</span>
						</xsl:if>
						<xsl:if test="@deprecated = 'false'">
							<xsl:value-of select="@name"/>
						</xsl:if>
					</a>
					</div>
				</xsl:for-each>
				
			</body>
		</html>
		
	</xsl:template>
	
</xsl:stylesheet>
