//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.service;

import java.io.StringReader;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.hivemind.Registry;

/**
 * @author Norbert Sándor
 */
public class TapdocContextImpl implements TapdocContext
{
    public TapdocContextImpl(Registry registry, FileObject javaDom, List<String> javadocLinks, List<String> libraryLocations,
            FileObject outputDirectory, List<String> tapdocLinks, DocumentGenerator documentGenerator)
    {
        this.registry = registry;
        this.documentGenerator = documentGenerator;
        try
        {
            if (javaDom == null)
            {
                javaDom = outputDirectory.resolveFile("tapdoc-javadom.xml");
            }
            if (!javaDom.exists())
            {
                javaDom.createFile();
                javaDom.close(); // FIXME why does not work without this?!?

                IOUtils.copy(new StringReader(
                        "<?xml version=\"1.0\" encoding=\"UTF-8\"?><tapdoc-javadom></tapdoc-javadom>"), javaDom
                        .getContent().getOutputStream());
            }

            this.javaDom = javaDom;
            this.javadocLinks = javadocLinks;
            this.tapdocLinks = tapdocLinks;
            this.libraryLocations = libraryLocations;
            this.outputDirectory = outputDirectory;
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }
    
    private final DocumentGenerator documentGenerator;
    
    public String getGeneratedFileNameExtension()
    {
        return documentGenerator.getGeneratedFileNameExtension();
    }
    
    private final Registry registry;
    
    public Registry getRegistry()
    {
        return registry;
    }

    private final FileObject javaDom;

    public FileObject getJavaDom()
    {
        return javaDom;
    }

    private final List<String> javadocLinks;

    public List<String> getJavadocLinks()
    {
        return javadocLinks;
    }

    private final List<String> tapdocLinks;

    public List<String> getTapdocLinks()
    {
        return tapdocLinks;
    }

    private final List<String> libraryLocations;

    public List<String> getLibraryLocations()
    {
        return libraryLocations;
    }

    private final FileObject outputDirectory;

    public FileObject getOutputDirectory()
    {
        return outputDirectory;
    }

}
