//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.model.Library;

/**
 * Provides metadata of Tapestry component libraries.
 * 
 * @author Norbert Sándor
 */
public interface ModelSource
{
    /**
     * @param libraryLocation
     *            location of the Tapestry library
     * @param ignoreAbstract
     *            ignore abstract classes when looking for Tapestry components
     * @return metadata of the specified Tapestry library
     */
    Library getLibraryModel(String libraryLocation, boolean ignoreAbstract);
}
