//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.service;

import java.lang.reflect.Method;
import java.util.List;

import com.erinors.tapestry.tapdoc.doclet.TapdocDoclet;

/**
 * Parser to extract information from the XML file, pregenerated by the Javadoc tool using the
 * {@link TapdocDoclet custom Tapdoc doclet}.
 * 
 * @author Norbert Sándor
 */
public interface JavadomParser
{
    /**
     * @param className
     *            name of a Java class
     * @return javadoc class comment or <code>null</code> if none
     */
    public String getClassComment(String className);

    /**
     * @param getter
     *            getter method of a property or <code>null</code> if none
     * @param setter
     *            setter method of the same property or <code>null</code> if none
     * @return javadoc comment of the specified property
     */
    public String getAccessorMethodComment(Method getter, Method setter);

    /**
     * Gets components annotated with ComponentClass.
     * @return
     */
    List<String> getAnnotatedComponent(String library, boolean ignoreAbstract);
}
