/*
 * Copyright (c) Erinors 2006. All rights reserved.
 */

package com.erinors.tapestry.tapdoc.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Registry;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.markup.MarkupWriterImpl;
import org.apache.tapestry.markup.UTFMarkupFilter;

import com.erinors.tapestry.tapdoc.model.Library;
import com.erinors.tapestry.tapdoc.util.TapdocPrefs;

public class GeneratorImpl implements Generator
{
    public GeneratorImpl(ClassResolver classResolver, FileNameGenerator fileNameGenerator, XmlGenerator xmlGenerator,
            ModelSource modelSource)
    {
        this.classResolver = classResolver;
        this.fileNameGenerator = fileNameGenerator;
        this.xmlGenerator = xmlGenerator;
        this.modelSource = modelSource;
    }

    private final ClassResolver classResolver;

    private final FileNameGenerator fileNameGenerator;

    private final XmlGenerator xmlGenerator;

    private final ModelSource modelSource;

    private TapdocContext context;

    public TapdocContext getContext()
    {
        return context;
    }

    public void generate(Registry registry, FileObject outputDirectory, FileObject generatedOutputDirectory,
            FileObject javaDom, TapdocPrefs prefs)
    {
        try
        {
            DocumentGenerator generator = (DocumentGenerator) registry.getService(
                    "com.erinors.tapestry.tapdoc.XdocDocumentGenerator", DocumentGenerator.class);
            // FIXME
            
            this.context = new TapdocContextImpl(registry, javaDom, prefs.getJavadocLinks(),
                    prefs.getLibraryLocations(), outputDirectory, prefs.getTapdocLinks(), generator);

            //
            // Generate XML
            //

            StringWriter buffer = new StringWriter();
            IMarkupWriter writer = new MarkupWriterImpl("text/xml", new PrintWriter(buffer), new UTFMarkupFilter());

            List<Library> libraryModels = new ArrayList<Library>();
            for (String libraryLocation : prefs.getLibraryLocations())
            {
                libraryModels.add(modelSource.getLibraryModel(libraryLocation, prefs.isIgnoreAbstract()));
            }

            xmlGenerator.generateXml(libraryModels).toXml(writer);
            String xml = buffer.toString();

            generator.generate(outputDirectory, generatedOutputDirectory, libraryModels, xml);
        }
        catch (FileSystemException e)
        {
            throw new RuntimeException(e);
        }
        finally
        {
            this.context = null;
        }
    }
}
