//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.service;

import java.util.HashMap;
import java.util.Map;

public class FileNameGeneratorImpl implements FileNameGenerator
{
    public FileNameGeneratorImpl(TapdocContext context)
    {
        this.context = context;
    }

    private final TapdocContext context;

    public String getLibraryDirectory(String libraryLocation)
    {
        assert libraryLocation != null && libraryLocation.startsWith("/") && libraryLocation.contains(".");
        return libraryLocation.substring(1, libraryLocation.lastIndexOf(".")).replaceAll("/", ".");
    }

    public String getComponentDirectory(String libraryLocation, String componentName)
    {
        assert libraryLocation != null && libraryLocation.startsWith("/") && libraryLocation.contains(".");
        assert componentName != null;
        return getLibraryDirectory(libraryLocation) + "/" + componentName;
    }

    public String getComponentIndexFile(String libraryLocation, String componentName, boolean forGenerating)
    {
        return getComponentDirectory(libraryLocation, componentName) + "/index."
                + (forGenerating ? context.getGeneratedFileNameExtension() : "html");
    }

    private Map<String, String> libraryNameCache = new HashMap<String, String>();

    public String extractLibraryName(String libraryLocation)
    {
        assert libraryLocation != null && libraryLocation.startsWith("/") && libraryLocation.contains(".");

        String name = libraryNameCache.get(libraryLocation);
        if (name == null)
        {
            name = libraryLocation.substring(libraryLocation.lastIndexOf("/") + 1, libraryLocation.lastIndexOf('.'));

            if (libraryNameCache.containsValue(name))
            {
                int index = 1;
                while (libraryNameCache.containsValue(name + " (" + index + ")"))
                {
                    index++;
                }

                name = name + " (" + index + ")";
            }

            libraryNameCache.put(libraryLocation, name);
        }

        return name;
    }
}
