/*
 * Copyright (c) Erinors 2006. All rights reserved.
 */

package com.erinors.tapestry.tapdoc.service;

public interface DocResolver
{
    /**
     * @return the URL of a Java type's or member's documentation.
     */
    public String getJavadocUrl(String type, String member);

    /**
     * Returns the URL of the given library's documentation:
     * <ul>
     * <li>if library is a local library then the returned URL will be relative to the documentation root</li>
     * <li>if the library is external then the returned URL will be absolute</li>
     * </ul>
     * 
     * @param libraryLocation
     * @return URL of the library's documentation
     */
    public String getLibraryUrl(String libraryLocation);

    public String getComponentUrl(String libraryLocation, String type);
}
