//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * Represents a parameter of a Tapestry component.
 * 
 * @author Norbert Sándor
 */
public final class Parameter implements Serializable
{
    private static final long serialVersionUID = 6789234348849006448L;

    private Set<String> aliases = new HashSet<String>();

    public Set<String> getAliases()
    {
        return aliases;
    }

    public void setAliases(Set<String> aliases)
    {
        this.aliases = aliases;
    }

    private String defaultValue;

    public String getDefaultValue()
    {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue)
    {
        this.defaultValue = defaultValue;
    }

    private String description;

    public String getDescription()
    {
        return description;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    private String name;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    private String type;

    public String getType()
    {
        return type;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    private boolean cached;

    public boolean isCached()
    {
        return cached;
    }

    public void setCached(boolean cached)
    {
        this.cached = cached;
    }

    private boolean deprecated;

    public boolean isDeprecated()
    {
        return deprecated;
    }

    public void setDeprecated(boolean deprecated)
    {
        this.deprecated = deprecated;
    }

    private boolean required;

    public boolean isRequired()
    {
        return required;
    }

    public void setRequired(boolean required)
    {
        this.required = required;
    }
}
