//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents a Tapestry component library.
 * 
 * @author Norbert Sándor
 */
public final class Library implements Serializable
{
    private static final long serialVersionUID = -1601950569735035020L;

    public Library(List<String> componentTypes)
    {
        this.componentTypes = new ArrayList<String>(componentTypes);
    }

    private List<String> componentTypes;

    public List<String> getComponentTypes()
    {
        return componentTypes;
    }

    public void addDocumentedComponent(String componentName)
    {
        componentTypes.add(componentName);
    }

    private List<Component> components = new ArrayList<Component>();

    public List<Component> getComponents()
    {
        return components;
    }

    private String description;

    public String getDescription()
    {
        return description;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    private String location;

    public String getLocation()
    {
        return location;
    }

    public void setLocation(String location)
    {
        this.location = location;
    }

    private String name;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }
}
