//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.mock;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/**
 * Almost empty servlet context implementation to be able to run Tapestry without a servlet container.
 * 
 * @author Norbert Sándor
 */
public class MockServletContext implements ServletContext
{
    public ServletContext getContext(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion()
    {
        throw new UnsupportedOperationException();
    }

    public int getMinorVersion()
    {
        throw new UnsupportedOperationException();
    }

    public String getMimeType(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public Set getResourcePaths(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String name) throws MalformedURLException
    {
        return getClass().getResource(name);
    }

    public InputStream getResourceAsStream(String name)
    {
        return getClass().getResourceAsStream(name);
    }

    public RequestDispatcher getRequestDispatcher(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getNamedDispatcher(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public Servlet getServlet(String arg0) throws ServletException
    {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServlets()
    {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServletNames()
    {
        throw new UnsupportedOperationException();
    }

    public void log(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public void log(Exception arg0, String arg1)
    {
        throw new UnsupportedOperationException();
    }

    public void log(String arg0, Throwable arg1)
    {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public String getServerInfo()
    {
        throw new UnsupportedOperationException();
    }

    public String getInitParameter(String arg0)
    {
        return null;
    }

    public Enumeration getInitParameterNames()
    {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public Enumeration getAttributeNames()
    {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String arg0, Object arg1)
    {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String arg0)
    {
        throw new UnsupportedOperationException();
    }

    public String getServletContextName()
    {
        throw new UnsupportedOperationException();
    }

}
