//
// Copyright (c) Erinors 2006-2007
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.erinors.tapestry.tapdoc.mock;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

/**
 * Almost &quot;empty&quot; servlet implementation to be able to run a subset of Tapestry's functionality without a
 * servlet container.
 * 
 * @author Norbert Sándor
 */
public class MockServlet extends HttpServlet
{
    public MockServlet(String applicationSpecificationPath)
    {
        this.applicationSpecificationPath = applicationSpecificationPath;
    }
    
    private final String applicationSpecificationPath;
    
    private final MockServletContext servletContext = new MockServletContext();

    @Override
    public ServletContext getServletContext()
    {
        return servletContext;
    }

    @Override
    public String getInitParameter(String name)
    {
        String value = null;
        
        if ("org.apache.tapestry.application-specification".equals(name))
        {
            value = applicationSpecificationPath;
        }
        
        return value;
    }

    @Override
    public String getServletName()
    {
        return "TapDoc Mock Servlet";
    }
}
