package net.sf.tacos.markup;

import org.apache.tapestry.IMarkupWriter;

/**
 * An easier to use {@link org.apache.tapestry.IMarkupWriter}.
 * 
 * @author Andreas Andreou
 */
public interface IExtendedMarkupWriter extends IMarkupWriter {
    /**
     * Starts an element that will not later be matched with an end() call
     * ( this is useful for elements that do not need closing tags ) and appends
     * the given attributes and values.
     * @see org.apache.tapestry.IMarkupWriter#beginEmpty(String)
     * @param tag The html tag to generate.
     * @param attributes An alterating list of attributes and values.
     * @return
     */
    IExtendedMarkupWriter createEmpty(String tag, String... attributes);

    /**
     * Starts a new element and appends
     * the given attributes and values.
     * @see org.apache.tapestry.IMarkupWriter#begin(String)
     * @param tag
     * @param attributes
     * @return
     */
    IExtendedMarkupWriter create(String tag, String... attributes);
}
