package net.sf.tacos.markup;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.markup.Attribute;

/**
 *
 */
public class ExtendedMarkupWriterImpl implements IExtendedMarkupWriter {
    private IMarkupWriter writer;

    public ExtendedMarkupWriterImpl(IMarkupWriter writer) {
        this.writer = writer;
    }

    public IExtendedMarkupWriter createEmpty(String tag, String... attributes) {
        writer.beginEmpty(tag);
        writeAttributesAndValues(attributes);
        return this;
    }

    public IExtendedMarkupWriter create(String tag, String... attributes) {
        writer.begin(tag);
        writeAttributesAndValues(attributes);
        return this;
    }

    private void writeAttributesAndValues(String... attributes) {
        for (int i=0; i<attributes.length; i+=2) {
            writer.attribute(attributes[i], attributes[i+1]);
        }
    }

    public void attribute(String name, int value) {
        writer.attribute(name, value);
    }

    public void attribute(String name, boolean value) {
        writer.attribute(name, value);
    }

    public void attribute(String name, String value) {
        writer.attribute(name, value);
    }

    public void attributeRaw(String name, String value) {
        writer.attributeRaw(name, value);
    }

    public void appendAttribute(String name, int value) {
        writer.appendAttribute(name, value);
    }

    public void appendAttribute(String name, boolean value) {
        writer.appendAttribute(name, value);
    }

    public void appendAttribute(String name, String value) {
        writer.appendAttribute(name, value);
    }

    public void appendAttributeRaw(String name, String value) {
        writer.appendAttributeRaw(name, value);
    }

    public boolean hasAttribute(String name) {
        return writer.hasAttribute(name);
    }

    public Attribute getAttribute(String name) {
        return writer.getAttribute(name);
    }

    public Attribute removeAttribute(String name) {
        return writer.removeAttribute(name);
    }

    public void clearAttributes() {
        writer.clearAttributes();
    }

    public void begin(String name) {
        writer.begin(name);
    }

    public void beginEmpty(String name) {
        writer.beginEmpty(name);
    }

    public boolean checkError() {
        return writer.checkError();
    }

    public void close() {
        writer.close();
    }

    public void closeTag() {
        writer.closeTag();
    }

    public void comment(String value) {
        writer.comment(value);
    }

    public void end() {
        writer.end();
    }

    public void end(String name) {
        writer.end(name);
    }

    public void flush() {
        writer.flush();
    }

    public NestedMarkupWriter getNestedWriter() {
        return writer.getNestedWriter();
    }

    public void print(char[] data, int offset, int length) {
        writer.print(data, offset, length);
    }

    public void print(char[] data, int offset, int length, boolean raw) {
        writer.print(data, offset, length, raw);
    }

    public void print(char value) {
        writer.print(value);
    }

    public void print(int value) {
        writer.print(value);
    }

    public void print(String value) {
        writer.print(value);
    }

    public void print(String value, boolean raw) {
        writer.print(value, raw);
    }

    public void println() {
        writer.println();
    }

    public void printRaw(char[] buffer, int offset, int length) {
        writer.printRaw(buffer, offset, length);
    }

    public void printRaw(String value) {
        writer.printRaw(value);
    }

    public String getContentType() {
        return writer.getContentType();
    }
}

