//Copyright 2005 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package net.sf.tacos.annotations.enhance;

import java.lang.reflect.Modifier;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.spec.InjectSpecification;

/**
 * @author Patrick Moore
 */
public class InjectParameterFlagWorker implements InjectEnhancementWorker {

    public void performEnhancement(EnhancementOperation op,
            InjectSpecification spec) {
        injectParameterFlag(op, spec.getObject(), spec.getProperty(), spec.getLocation());
    }
    void injectParameterFlag(EnhancementOperation op, String parameterName, String propertyName,
            Location location)
    {
        Defense.notNull(op, "op");
        Defense.notNull(parameterName, "parameterName");
        Defense.notNull(propertyName, "propertyName");

        Class propertyType = op.getPropertyType(propertyName);

        // null means no property at all; it's just in the XML
        // which is ok. Otherwise, make sure it is exactly boolean.

        if (propertyType != null && propertyType != boolean.class)
            throw new ApplicationRuntimeException("Property " + propertyName + " must be boolean",
                    location, null);

        op.claimReadonlyProperty(propertyName);
        
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.add("return isParameterBound(");
        builder.addQuoted(parameterName);
        builder.addln(");");
        builder.end();

        String methodName = op.getAccessorMethodName(propertyName);

        MethodSignature sig = new MethodSignature(boolean.class, methodName, null, null);

        op.addMethod(Modifier.PUBLIC, sig, builder.toString(), location);
    }

}
