//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package net.sf.tacos.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for injecting an ILink to a specific page,
 * using the page service.<p/>
 * Use it on an abstract, parameterless
 * page or component method that returns ILink. 
 *
 * @author Ming Jiang
 * @author Andreas Andreou
 */
@Target( { ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface InjectPageLink {
    /**
     * The name of the page for which to inject the ILink.
     * @return
     */
    String value();

    /**
     * Set to true if the page is to be found on the current namespace. Otherwise (the
     * default), it is assumed to exist in the application (global) namespace.
     * @return
     */
    boolean currentNamespace() default false;
}