//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package net.sf.tacos.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;

/**
 * @author Ming Jiang
 * @author Andreas Andreou
 */

public class InjectExternalLinkAnnotationWorker implements
		MethodAnnotationEnhancementWorker {

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec,
            Method method, Location location) {
        if (!method.getReturnType().equals(ILink.class))
                throw new ApplicationRuntimeException("injectExternalLink annotation must return ILink");

        InjectExternalLink injectExternalLink = method.getAnnotation(InjectExternalLink.class);

        String pageName = injectExternalLink.value();

        BodyBuilder builder = new BodyBuilder();

        builder.begin();
        builder.addln("String pageName=\"{0}\";", pageName);
        if (injectExternalLink.currentNamespace())
            builder.addln("pageName=getNamespace().constructQualifiedName(pageName);");        

        Class[] parameterTypes = method.getParameterTypes();
        int paramCount = Tapestry.size(parameterTypes);

        if (paramCount > 0) {
                if (parameterTypes[0].isArray()) {
                        builder.addln("return getPage().getRequestCycle().getInfrastructure().getServiceMap()." +
                                "getService(org.apache.tapestry.Tapestry.EXTERNAL_SERVICE).getLink(false, new org.apache.tapestry.engine.ExternalServiceParameter(pageName,$1));");
                } else {
                        builder.addln("java.lang.Object[] params = new java.lang.Object[{0}];", paramCount);
                        for (int i = 0; i < paramCount; i++) {
                                builder.add("params[{0}] = ", i);
                                if (parameterTypes[i].isPrimitive())
                                        builder.add("($w) ");
                                builder.addln("${0};", i + 1);
                        }
                        builder.addln("return getPage().getRequestCycle().getInfrastructure().getServiceMap()." +
                                "getService(org.apache.tapestry.Tapestry.EXTERNAL_SERVICE).getLink(false, new org.apache.tapestry.engine.ExternalServiceParameter(pageName,params));");
                }
        }

        builder.end();

        op.addMethod(Modifier.PUBLIC, new MethodSignature(method), builder
                        .toString(), location);

        if (isGetter(method))
                op.claimReadonlyProperty(AnnotationUtils.getPropertyName(method));
    }

    boolean isGetter(Method method) {
            return method.getName().startsWith("get")
                            && method.getParameterTypes().length == 0;
    }
}