package net.sf.tacos.annotations;

import java.lang.annotation.Target;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Documented;

/**
 * Annotation used on any (non-abstract) page or component method that returns a value.
 * <p/>
 * It caches the method result during the current request cycle, meaning that subsequent calls
 * do not reevaluate the method's body.
 * 
 * @author Andreas Andreou
 */
@Target(
{ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Cached {
}

