/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.annotations.enhance;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.spec.InjectSpecification;

public class InjectParameterFlagWorker
implements InjectEnhancementWorker {
    public void performEnhancement(EnhancementOperation op, InjectSpecification spec) {
        this.injectParameterFlag(op, spec.getObject(), spec.getProperty(), spec.getLocation());
    }

    void injectParameterFlag(EnhancementOperation op, String parameterName, String propertyName, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)parameterName, (String)"parameterName");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Class propertyType = op.getPropertyType(propertyName);
        if (propertyType != null && propertyType != Boolean.TYPE) {
            throw new ApplicationRuntimeException("Property " + propertyName + " must be boolean", location, null);
        }
        op.claimReadonlyProperty(propertyName);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.add("return isParameterBound(");
        builder.addQuoted(parameterName);
        builder.addln(");");
        builder.end();
        String methodName = op.getAccessorMethodName(propertyName);
        MethodSignature sig = new MethodSignature(Boolean.TYPE, methodName, null, null);
        op.addMethod(1, sig, builder.toString(), location);
    }
}

