/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io.dozer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dozer.DozerBeanMapper;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.api.FieldsMappingOption;
import org.dozer.loader.api.FieldsMappingOptions;
import org.dozer.loader.api.TypeMappingBuilder;
import org.dozer.loader.api.TypeMappingOption;
import org.dozer.loader.api.TypeMappingOptions;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.AbstractCsvWriter;
import org.supercsv.io.dozer.CsvDozerBeanData;
import org.supercsv.io.dozer.ICsvDozerBeanWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvDozerBeanWriter
extends AbstractCsvWriter
implements ICsvDozerBeanWriter {
    private final DozerBeanMapper dozerBeanMapper;
    private final CsvDozerBeanData beanData = new CsvDozerBeanData();
    private final List<Object> processedColumns = new ArrayList<Object>();

    public CsvDozerBeanWriter(Writer writer, CsvPreference preference) {
        super(writer, preference);
        this.dozerBeanMapper = new DozerBeanMapper();
    }

    public CsvDozerBeanWriter(Writer writer, CsvPreference preference, DozerBeanMapper dozerBeanMapper) {
        super(writer, preference);
        if (dozerBeanMapper == null) {
            throw new NullPointerException("dozerBeanMapper should not be null");
        }
        this.dozerBeanMapper = dozerBeanMapper;
    }

    @Override
    public void configureBeanMapping(Class<?> clazz, String[] fieldMapping) {
        this.dozerBeanMapper.addMapping((BeanMappingBuilder)new MappingBuilder(clazz, fieldMapping));
    }

    @Override
    public void write(Object source) throws IOException {
        if (source == null) {
            throw new NullPointerException("object to write should not be null");
        }
        super.incrementRowAndLineNo();
        this.beanData.getColumns().clear();
        this.dozerBeanMapper.map(source, (Object)this.beanData);
        super.writeRow(this.beanData.getColumns());
    }

    @Override
    public void write(Object source, CellProcessor[] processors) throws IOException {
        if (source == null) {
            throw new NullPointerException("object to write should not be null");
        }
        if (processors == null) {
            throw new NullPointerException("processors should not be null");
        }
        super.incrementRowAndLineNo();
        this.beanData.getColumns().clear();
        this.dozerBeanMapper.map(source, (Object)this.beanData);
        Util.executeCellProcessors(this.processedColumns, this.beanData.getColumns(), (CellProcessor[])processors, (int)this.getLineNumber(), (int)this.getRowNumber());
        super.writeRow(this.processedColumns);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingBuilder
    extends BeanMappingBuilder {
        private final Class<?> clazz;
        private final String[] fieldMapping;

        public MappingBuilder(Class<?> clazz, String[] fieldMapping) {
            if (clazz == null) {
                throw new NullPointerException("clazz should not be null");
            }
            if (fieldMapping == null) {
                throw new NullPointerException("fieldMapping should not be null");
            }
            this.clazz = clazz;
            this.fieldMapping = Arrays.copyOf(fieldMapping, fieldMapping.length);
        }

        protected void configure() {
            TypeMappingBuilder mappingBuilder = this.mapping(this.clazz, this.type(CsvDozerBeanData.class).mapNull(true), new TypeMappingOption[]{TypeMappingOptions.oneWay(), TypeMappingOptions.wildcard((boolean)false)});
            for (int i = 0; i < this.fieldMapping.length; ++i) {
                String mapping = this.fieldMapping[i];
                if (mapping == null) {
                    throw new NullPointerException(String.format("fieldMapping at index %d should not be null", i));
                }
                mappingBuilder.fields(mapping, "columns[" + i + "]", new FieldsMappingOption[]{FieldsMappingOptions.copyByReference()});
            }
        }
    }
}

