/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CopyByReference {
    private static final String WILDCARD = "*";
    private String mask;
    private Pattern pattern;

    public CopyByReference(String mask) {
        this.mask = mask;
        this.pattern = this.compilePattern(mask);
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
        this.pattern = this.compilePattern(mask);
    }

    private Pattern compilePattern(String mask) {
        String regexp = StringUtils.replace((String)mask, (String)".", (String)"\\.");
        regexp = StringUtils.replace((String)regexp, (String)WILDCARD, (String)".*?");
        return Pattern.compile(regexp);
    }

    public boolean matches(String destFieldTypeName) {
        Matcher matcher = this.pattern.matcher(destFieldTypeName);
        return matcher.matches();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

