/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.io.Files;
import net.sf.staccatocommons.io.internal.FilePredicate;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.internal.TopLevelFunction;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public class Files {
    private static final Function FILE_NAME = Files.fileNameInitializer();
    private static final Function FILE_PATH = Files.filePathInitializer();

    @Constant
    public static Function<File, String> fileName() {
        return FILE_NAME;
    }

    @Constant
    public static Function<File, String> filePath() {
        return FILE_PATH;
    }

    public static Predicate<File> suffix(String ... suffixes) {
        Ensure.isNotNull((String)"var0", (Object)suffixes);
        return new FilePredicate((FileFilter)new SuffixFileFilter(suffixes));
    }

    public static Reader openReader(@NonNull File file) {
        Ensure.isNotNull((String)"var0", (Object)file);
        try {
            return new FileReader(file);
        }
        catch (FileNotFoundException e) {
            return (Reader)Files.handleFileNotFound(file, e);
        }
    }

    public static FileInputStream openInputStream(@NonNull File file) {
        Ensure.isNotNull((String)"var0", (Object)file);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return (FileInputStream)Files.handleFileNotFound(file, e);
        }
    }

    public static FileChannel openChannel(@NonNull File file) {
        Ensure.isNotNull((String)"var0", (Object)file);
        return Files.openInputStream(file).getChannel();
    }

    protected static <T> T handleFileNotFound(File file, FileNotFoundException e) {
        Ensure.thatVar((String)"file", (Object)file, (boolean)file.isFile(), (String)"must be a regular file", (Object[])new Object[0]);
        Ensure.thatVar((String)"file", (Object)file, (boolean)file.exists(), (String)"must exist", (Object[])new Object[0]);
        Ensure.thatVar((String)"file", (Object)file, (boolean)file.canRead(), (String)"must be readable", (Object[])new Object[0]);
        throw SoftException.soften((Throwable)e);
    }

    private static Function fileNameInitializer() {
        class FileNameFunction
        extends TopLevelFunction<File, String> {
            private static final long serialVersionUID = 247639349321744212L;

            FileNameFunction() {
            }

            public String apply(File arg) {
                return arg.getName();
            }
        }
        return new FileNameFunction();
    }

    private static Function filePathInitializer() {
        class FilePathFunction
        extends TopLevelFunction<File, String> {
            private static final long serialVersionUID = 8740286164884158913L;

            FilePathFunction() {
            }

            public String apply(File arg) {
                return arg.getPath();
            }
        }
        return new FilePathFunction();
    }
}

