/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.BaseException;
import java.io.Reader;
import java.io.Writer;
import net.sf.staccatocommons.io.serialization.AbstractCharSerializationManager;
import org.apache.commons.lang.SerializationException;

public class XStreamXmlSerializationManager
extends AbstractCharSerializationManager {
    private final XStream xstream;

    public XStreamXmlSerializationManager() {
        this(new XStream());
    }

    public XStreamXmlSerializationManager(XStream xstream) {
        this.xstream = xstream;
    }

    @Override
    public <T> T deserialize(Reader reader) {
        try {
            return (T)this.xstream.fromXML(reader);
        }
        catch (BaseException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    @Override
    public void serialize(Object object, Writer writer) {
        try {
            this.xstream.toXML(object, writer);
        }
        catch (BaseException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public XStream getXstream() {
        return this.xstream;
    }
}

