/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io.preferences;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.io.preferences.ObjectPreferences;
import net.sf.staccatocommons.io.serialization.CharSerializationManager;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.commons.lang.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharSerializationObjectPreferences
implements ObjectPreferences {
    private static final Logger LOG = LoggerFactory.getLogger(CharSerializationObjectPreferences.class);
    private final Preferences preferences;
    private final CharSerializationManager serializationManager;

    public CharSerializationObjectPreferences(@NonNull Preferences preferences, @NonNull CharSerializationManager stream) {
        Ensure.isNotNull((String)"var1", (Object)stream);
        Ensure.isNotNull((String)"var0", (Object)preferences);
        this.preferences = preferences;
        this.serializationManager = stream;
    }

    @Override
    @NonNull
    public Preferences getNode() {
        return this.preferences;
    }

    @Override
    public void put(@NonNull String key, Object value) {
        Ensure.isNotNull((String)"var0", (Object)key);
        this.preferences.put(key, this.serializationManager.serialize(value));
    }

    @Override
    public <T> T get(@NonNull String key, T defaultValue) {
        Ensure.isNotNull((String)"var0", (Object)key);
        String valueAsString = this.preferences.get(key, null);
        if (valueAsString == null) {
            LOG.debug("Preference " + key + "not found. Loading defaults");
            return defaultValue;
        }
        try {
            return this.serializationManager.deserialize(valueAsString);
        }
        catch (SerializationException e) {
            LOG.warn("Could not read valid value for preference " + key + ", loading defaults " + defaultValue);
            LOG.debug("Loading preference " + key + "threw an exception", (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        this.preferences.flush();
    }

    @Override
    public void sync() throws BackingStoreException {
        this.preferences.sync();
    }

    @Override
    public void remove(String key) {
        this.preferences.remove(key);
    }

    public static ObjectPreferences userNodeForPackage(@NonNull Class<?> clazz, @NonNull CharSerializationManager serializarionManager) {
        Ensure.isNotNull((String)"var1", (Object)serializarionManager);
        Ensure.isNotNull((String)"var0", clazz);
        return new CharSerializationObjectPreferences(Preferences.userNodeForPackage(clazz), serializarionManager);
    }

    public static ObjectPreferences systemNodeForPackage(Class<?> clazz, CharSerializationManager serializarionManager) {
        return new CharSerializationObjectPreferences(Preferences.systemNodeForPackage(clazz), serializarionManager);
    }
}

