/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.io.internal;

import java.util.concurrent.Callable;
import net.sf.staccatocommons.lang.SoftException;

public class Handle {
    private Handle() {
    }

    public static <ExceptionType extends Exception, R> R throwing(Callable<R> thunk, Class<ExceptionType> exceptionClass) throws ExceptionType {
        try {
            return thunk.call();
        }
        catch (Exception e) {
            if (Handle.shouldCatch(exceptionClass, e)) {
                throw e;
            }
            throw SoftException.soften((Throwable)e);
        }
    }

    public static <ExceptionType1 extends Exception, ExceptionType2 extends Exception, R> R throwing(Callable<R> thunk, Class<ExceptionType1> exceptionClass1, Class<ExceptionType2> exceptionClass2) throws ExceptionType1, ExceptionType2 {
        try {
            return thunk.call();
        }
        catch (Exception e) {
            if (Handle.shouldCatch(exceptionClass1, e)) {
                throw e;
            }
            if (Handle.shouldCatch(exceptionClass2, e)) {
                throw e;
            }
            throw SoftException.soften((Throwable)e);
        }
    }

    private static <ExceptionType1> boolean shouldCatch(Class<ExceptionType1> exceptionClass, Exception e) {
        return exceptionClass.isAssignableFrom(e.getClass());
    }
}

