/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.instrument.internal;

import java.util.Collection;
import java.util.LinkedList;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.instrument.handler.AnnotationHandler;
import net.sf.staccatocommons.lang.block.Block2;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;

class AnnotationProcessor<HandlerType extends AnnotationHandler> {
    private final Collection<HandlerType> handlers = new LinkedList<HandlerType>();

    public void processUsing(Object[] annotations, Block2<Object, HandlerType> block) {
        Object[] objectArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Object annotation = objectArray[n2];
            for (AnnotationHandler handler : this.getHandlers(annotation)) {
                block.exec(annotation, (Object)handler);
            }
            ++n2;
        }
    }

    private Stream<HandlerType> getHandlers(final Object annotation) {
        return Streams.from(this.handlers).filter((Evaluable)new AbstractPredicate<HandlerType>(){

            public boolean eval(HandlerType argument) {
                return argument.getSupportedAnnotationType().isAssignableFrom(annotation.getClass());
            }
        });
    }

    public void addHandler(HandlerType handler) {
        this.handlers.add(handler);
    }
}

