/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.instrument.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.instrument.InstrumentationRunner;
import net.sf.staccatocommons.instrument.config.InstrumenterConfigurer;
import net.sf.staccatocommons.io.Directory;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class InstrumentMojoSupport {
    private final String location;
    private final Artifact artifact;
    private final Collection<Artifact> projectArtifactsList;
    private final Mojo mojo;

    public InstrumentMojoSupport(@NonNull Mojo mojo, @NonNull String location, @NonNull Artifact artifact, Collection<Artifact> projectArtifactsList) {
        Ensure.isNotNull((String)"var2", (Object)artifact);
        Ensure.isNotNull((String)"var1", (Object)location);
        Ensure.isNotNull((String)"var0", (Object)mojo);
        Ensure.isNotNull((String)"mojo", (Object)mojo);
        Ensure.isNotNull((String)"location", (Object)location);
        Ensure.isNotNull((String)"artifact", (Object)artifact);
        Ensure.isNotNull((String)"projectArtifactsList", projectArtifactsList);
        this.mojo = mojo;
        this.location = location;
        this.artifact = artifact;
        this.projectArtifactsList = projectArtifactsList;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.mojo.getLog().info((CharSequence)("Instrumenting classes located in " + this.location));
        String extraClasspath = this.createClassPathString();
        this.mojo.getLog().debug((CharSequence)("Using classpath " + extraClasspath));
        try {
            InstrumentationRunner.runInstrumentation(this.createConfigurer(), new Directory(this.location), extraClasspath);
        }
        catch (Exception e) {
            this.mojo.getLog().error((CharSequence)e.getMessage());
            throw new MojoExecutionException("Unexpected error", e);
        }
        this.mojo.getLog().info((CharSequence)"Classes instrumented sucessfully");
    }

    private String createClassPathString() {
        return Streams.from(this.projectArtifactsList).skip((Object)this.artifact).map((Function)new AbstractFunction<Artifact, String>(){

            public String apply(Artifact arg) {
                try {
                    return arg.getFile().getCanonicalPath();
                }
                catch (IOException e) {
                    throw SoftException.soften((Throwable)e);
                }
            }
        }).joinStrings(File.pathSeparator);
    }

    @NonNull
    protected abstract InstrumenterConfigurer createConfigurer();
}

