/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.instrument.context.internal;

import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.instrument.context.AnnotationContext;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.slf4j.Logger;

public abstract class AbstractAnnotationContext
implements AnnotationContext {
    private final Logger logger;
    private final ClassPool classPool;
    private Set<String> presentAnnotations;

    public AbstractAnnotationContext(@NonNull ClassPool pool, @NonNull Logger logger) {
        Ensure.isNotNull((String)"pool", (Object)pool);
        Ensure.isNotNull((String)"logger", (Object)logger);
        this.logger = logger;
        this.classPool = pool;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void logDebugMessage(String message, Object ... arguments) {
        this.getLogger().debug(message, arguments);
    }

    @Override
    public void logInfoMessage(String message, Object ... arguments) {
        this.getLogger().info(message, arguments);
    }

    @Override
    public void logWarnMessage(String message, Object ... arguments) {
        this.getLogger().warn(message, arguments);
    }

    @Override
    public void logErrorMessage(String message, Object ... arguments) {
        this.getLogger().error(message, arguments);
    }

    @Override
    public final ClassPool getClassPool() {
        return this.classPool;
    }

    @Override
    public CtClass getClass(String className) throws NotFoundException {
        Ensure.isNotNull((String)"className", (Object)className);
        return this.getClassPool().get(className);
    }

    public Set<String> getPresentAnnotationsTypes(Object[] annotations) {
        if (this.presentAnnotations == null) {
            this.presentAnnotations = Streams.cons((Object[])annotations).map((Function)new AbstractFunction<Object, String>(){

                public String apply(Object arg) {
                    return arg.getClass().getName();
                }
            }).toSet();
        }
        return this.presentAnnotations;
    }

    @Override
    public String getPackage() {
        try {
            return this.getDeclaringClass().getPackageName();
        }
        catch (NotFoundException e) {
            throw SoftException.soften((Throwable)e);
        }
    }
}

