/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.instrument.internal;

import java.lang.annotation.Annotation;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import net.sf.staccatocommons.check.Validate;
import net.sf.staccatocommons.instrument.config.InstrumentationMark;
import net.sf.staccatocommons.instrument.config.InstrumenterConfiguration;
import net.sf.staccatocommons.instrument.context.internal.DefaultArgumentAnnotationContext;
import net.sf.staccatocommons.instrument.context.internal.DefaultClassAnnotationContext;
import net.sf.staccatocommons.instrument.context.internal.DefaultConstructorAnnotationContext;
import net.sf.staccatocommons.instrument.context.internal.DefaultMethodAnnotationContext;
import net.sf.staccatocommons.instrument.handler.AnnotationHandler;
import net.sf.staccatocommons.instrument.handler.ArgumentAnnotationHandler;
import net.sf.staccatocommons.instrument.handler.ClassAnnotationHandler;
import net.sf.staccatocommons.instrument.handler.ConstructorAnnotationHandler;
import net.sf.staccatocommons.instrument.handler.MethodAnnotationHandler;
import net.sf.staccatocommons.instrument.internal.AnnotationProcessor;
import net.sf.staccatocommons.instrument.internal.Instrumenter;
import net.sf.staccatocommons.lang.block.Block2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumenterImpl
implements InstrumenterConfiguration,
Instrumenter {
    private final Logger logger = LoggerFactory.getLogger((String)"Processor-Logger");
    private final AnnotationProcessor<ClassAnnotationHandler> classProcessor = new AnnotationProcessor();
    private final AnnotationProcessor<MethodAnnotationHandler> methodProcessor = new AnnotationProcessor();
    private final AnnotationProcessor<ArgumentAnnotationHandler> argumentProcessor = new AnnotationProcessor();
    private final AnnotationProcessor<ConstructorAnnotationHandler> constructorProcessor = new AnnotationProcessor();
    private InstrumentationMark instrumentationMark;
    private final ClassPool classPool;
    private int handlersCount;

    public InstrumenterImpl(ClassPool classPool) {
        this.classPool = classPool;
    }

    @Override
    public InstrumenterConfiguration setInstrumentationMark(InstrumentationMark instrumentationMark) {
        this.instrumentationMark = instrumentationMark;
        return this;
    }

    public InstrumenterConfiguration addAnnotationHanlder(AnnotationHandler handler) {
        if (handler instanceof ClassAnnotationHandler) {
            this.classProcessor.addHandler((ClassAnnotationHandler)handler);
        }
        if (handler instanceof ArgumentAnnotationHandler) {
            this.argumentProcessor.addHandler((ArgumentAnnotationHandler)handler);
        }
        if (handler instanceof ConstructorAnnotationHandler) {
            this.constructorProcessor.addHandler((ConstructorAnnotationHandler)handler);
        }
        if (handler instanceof MethodAnnotationHandler) {
            this.methodProcessor.addHandler((MethodAnnotationHandler)handler);
        }
        ++this.handlersCount;
        return this;
    }

    public void ensureConfigured() {
        Validate.throwing(IllegalStateException.class).isNotNull("instrumentarionMark", (Object)this.instrumentationMark).isGreaterThan("handlers.count", (Comparable)Integer.valueOf(this.handlersCount), (Comparable)Integer.valueOf(0));
    }

    @Override
    public void instrumentClass(CtClass clazz) throws CannotCompileException, ClassNotFoundException {
        if (clazz.isInterface()) {
            return;
        }
        if (this.alreadyProcessed(clazz)) {
            this.logger.debug("Class {} was already processed. Ignoring", (Object)clazz);
            return;
        }
        final DefaultClassAnnotationContext context = new DefaultClassAnnotationContext(this.classPool, this.logger, clazz);
        this.classProcessor.processUsing(clazz.getAvailableAnnotations(), new Block2<Object, ClassAnnotationHandler>(){

            protected void softExec(Object annotation, ClassAnnotationHandler handler) throws Exception {
                handler.preProcessAnnotatedClass((Annotation)annotation, context);
            }
        });
        CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
        int n = ctMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtMethod method = ctMethodArray[n2];
            if (!Modifier.isAbstract((int)method.getModifiers())) {
                this.instrumentMethod(method);
            }
            ++n2;
        }
        ctMethodArray = clazz.getDeclaredConstructors();
        n = ctMethodArray.length;
        n2 = 0;
        while (n2 < n) {
            CtMethod constructor = ctMethodArray[n2];
            this.instrumentConstructor((CtConstructor)constructor);
            ++n2;
        }
        this.classProcessor.processUsing(clazz.getAvailableAnnotations(), new Block2<Object, ClassAnnotationHandler>(){

            protected void softExec(Object annotation, ClassAnnotationHandler handler) throws Exception {
                handler.postProcessAnnotatedClass((Annotation)annotation, context);
            }
        });
        this.markAsProcessed(clazz);
    }

    private void markAsProcessed(CtClass clazz) {
        clazz.setAttribute(this.instrumentationMark.getMarkAttributeName(), this.instrumentationMark.getMarkAttributeValue());
    }

    private boolean alreadyProcessed(CtClass clazz) {
        return clazz.getAttribute(this.instrumentationMark.getMarkAttributeName()) != null;
    }

    private void instrumentMethod(CtMethod method) throws CannotCompileException, ClassNotFoundException {
        final DefaultMethodAnnotationContext methodContext = new DefaultMethodAnnotationContext(this.classPool, this.logger);
        methodContext.setMethod(method);
        Object[] availableAnnotations = method.getAvailableAnnotations();
        this.methodProcessor.processUsing(availableAnnotations, new Block2<Object, MethodAnnotationHandler>(){

            protected void softExec(Object annotation, MethodAnnotationHandler handler) throws Exception {
                handler.preProcessAnnotatedMethod((Annotation)annotation, methodContext);
            }
        });
        this.instrumentArguments((CtBehavior)method);
        this.methodProcessor.processUsing(availableAnnotations, new Block2<Object, MethodAnnotationHandler>(){

            protected void softExec(Object annotation, MethodAnnotationHandler handler) throws Exception {
                handler.postProcessAnnotatedMethod((Annotation)annotation, methodContext);
            }
        });
    }

    private void instrumentConstructor(CtConstructor constructor) throws CannotCompileException, ClassNotFoundException {
        final DefaultConstructorAnnotationContext context = new DefaultConstructorAnnotationContext(this.classPool, this.logger);
        context.setConstructor(constructor);
        Object[] availableAnnotations = constructor.getAvailableAnnotations();
        this.constructorProcessor.processUsing(availableAnnotations, new Block2<Object, ConstructorAnnotationHandler>(){

            protected void softExec(Object annotation, ConstructorAnnotationHandler handler) throws Exception {
                handler.preProcessAnnotatedConstructor((Annotation)annotation, context);
            }
        });
        this.instrumentArguments((CtBehavior)constructor);
        this.constructorProcessor.processUsing(availableAnnotations, new Block2<Object, ConstructorAnnotationHandler>(){

            protected void softExec(Object annotation, ConstructorAnnotationHandler handler) throws Exception {
                handler.postProcessAnnotatedConstructor((Annotation)annotation, context);
            }
        });
    }

    private void instrumentArguments(CtBehavior behaviour) throws CannotCompileException {
        Object[][] parameterAnnotations = behaviour.getAvailableParameterAnnotations();
        final DefaultArgumentAnnotationContext argumentContext = new DefaultArgumentAnnotationContext(this.classPool, this.logger);
        argumentContext.setBehavior(behaviour);
        int i = 0;
        while (i < parameterAnnotations.length) {
            argumentContext.setParameterNumber(i);
            this.argumentProcessor.processUsing(parameterAnnotations[i], new Block2<Object, ArgumentAnnotationHandler>(){

                protected void softExec(Object annotation, ArgumentAnnotationHandler handler) throws Exception {
                    handler.processAnnotatedArgument((Annotation)annotation, argumentContext);
                }
            });
            ++i;
        }
    }
}

