/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.instrument;

import java.io.File;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.instrument.config.InstrumenterConfigurer;
import net.sf.staccatocommons.instrument.internal.ClassNames;
import net.sf.staccatocommons.instrument.internal.Instrumenter;
import net.sf.staccatocommons.instrument.internal.InstrumenterImpl;
import net.sf.staccatocommons.io.Directory;
import net.sf.staccatocommons.io.Files;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class InstrumentationRunner {
    private InstrumentationRunner() {
    }

    public static void runInstrumentation(@NonNull InstrumenterConfigurer configurer, @NonNull Directory processDirectory, @NonNull String extraPath) throws Exception {
        Ensure.isNotNull((String)"var2", (Object)extraPath);
        Ensure.isNotNull((String)"var1", (Object)processDirectory);
        Ensure.isNotNull((String)"var0", (Object)configurer);
        ClassPool classPool = new ClassPool(true);
        classPool.appendPathList(extraPath);
        classPool.appendClassPath(processDirectory.getAbsolutePath());
        InstrumenterImpl instrumenter = new InstrumenterImpl(classPool);
        configurer.configureInstrumenter(instrumenter);
        instrumenter.ensureConfigured();
        new InstrumentationContext(instrumenter, processDirectory, classPool).doInstrument();
    }

    private static class InstrumentationContext {
        private Directory processDirectory;
        private ClassPool classPool;
        private Instrumenter classInstrumenter;

        private InstrumentationContext(Instrumenter classInstrumenter, Directory processDirectory, ClassPool pool) throws NotFoundException {
            this.classInstrumenter = classInstrumenter;
            this.processDirectory = processDirectory;
            this.classPool = pool;
        }

        private void processAndWriteClass(Directory baseDir, File classfile) throws Exception {
            CtClass clazz = this.classPool.get(ClassNames.getClassName(baseDir, classfile));
            this.classInstrumenter.instrumentClass(clazz);
            if (clazz.isModified()) {
                clazz.writeFile(this.processDirectory.getAbsolutePath());
            }
            clazz.detach();
        }

        private void doInstrument() throws Exception {
            for (File classfile : this.processDirectory.getRecurseFileStream().filter((Evaluable)Files.suffix((String[])new String[]{".class"}))) {
                this.processAndWriteClass(this.processDirectory, classfile);
            }
        }
    }
}

