/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.predicate;

import java.util.Arrays;
import java.util.Collection;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.lang.predicate.internal.All;
import net.sf.staccatocommons.lang.predicate.internal.Any;
import net.sf.staccatocommons.lang.predicate.internal.Equals;
import net.sf.staccatocommons.lang.predicate.internal.EvaluablePredicate;
import net.sf.staccatocommons.lang.predicate.internal.False;
import net.sf.staccatocommons.lang.predicate.internal.InPredicate;
import net.sf.staccatocommons.lang.predicate.internal.NullPredicates;
import net.sf.staccatocommons.lang.predicate.internal.Same;
import net.sf.staccatocommons.lang.predicate.internal.True;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Predicates {
    private Predicates() {
    }

    @Constant
    public static <T> Predicate<T> true_() {
        return True.getInstance();
    }

    @Constant
    public static <T> Predicate<T> false_() {
        return False.getInstance();
    }

    @Constant
    public static <T> Predicate<T> notNull() {
        return NullPredicates.notNull();
    }

    @Constant
    public static <T> Predicate<T> null_() {
        return NullPredicates.null_();
    }

    public static <T> Predicate<T> equal(T value) {
        return new Equals<T>(value);
    }

    public static <T> Predicate<T> same(T value) {
        return new Same<T>(value);
    }

    public static <T> Predicate<T> isInstanceOf(final @NonNull Class<? extends T> clazz) {
        Ensure.isNotNull((String)"var0", clazz);
        return new AbstractPredicate<T>(){

            @Override
            public boolean eval(T argument) {
                return clazz.isAssignableFrom(argument.getClass());
            }
        };
    }

    public static <T> Predicate<T> in(T ... values) {
        Ensure.isNotNull((String)"var0", values);
        return new InPredicate<T>(values);
    }

    public static <T> Predicate<T> in(@NonNull Collection<T> values) {
        Ensure.isNotNull((String)"var0", values);
        return new InPredicate<T>(values);
    }

    public static <T> Predicate<T> all(Evaluable<T> ... predicates) {
        Ensure.isNotNull((String)"var0", predicates);
        return Predicates.all((Iterable)Arrays.asList(predicates));
    }

    public static <T> Predicate<T> all(@NonNull Iterable<Evaluable<T>> predicates) {
        Ensure.isNotNull((String)"var0", predicates);
        return new All<T>(predicates);
    }

    public static <T> Predicate<T> any(Evaluable<T> ... predicates) {
        Ensure.isNotNull((String)"var0", predicates);
        return Predicates.any((Iterable)Arrays.asList(predicates));
    }

    public static <T> Predicate<T> any(@NonNull Iterable<Evaluable<T>> predicates) {
        Ensure.isNotNull((String)"var0", predicates);
        return new Any<T>(predicates);
    }

    public static <T> Predicate<T> from(@NonNull Evaluable<? super T> evaluable) {
        Ensure.isNotNull((String)"var0", evaluable);
        if (evaluable instanceof AbstractPredicate) {
            return (Predicate)evaluable;
        }
        return new EvaluablePredicate<T>(evaluable);
    }
}

