/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.dynamic.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.dynamic.AbstractDynamic;
import net.sf.staccatocommons.dynamic.Dynamic;
import net.sf.staccatocommons.dynamic.Dynamics;
import net.sf.staccatocommons.dynamic.MessageNotUnderstoodException;
import net.sf.staccatocommons.dynamic.MethodEvaluationException;
import net.sf.staccatocommons.dynamic.internal.MethodDescriptor;
import net.sf.staccatocommons.dynamic.internal.PrimitiveWrappers;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public final class ReflectiveDynamic
extends AbstractDynamic {
    private final Object target;
    private static final Map<MethodDescriptor, Method> CACHE = Collections.synchronizedMap(new WeakHashMap());

    public ReflectiveDynamic(@NonNull Object target) {
        Ensure.isNotNull((String)"var0", (Object)target);
        this.target = target;
    }

    @Override
    @ForceRestrictions
    public <T> T send(@NonNull String selector, Object ... args) {
        Ensure.isNotNull((String)"var1", (Object)args);
        Ensure.isNotNull((String)"var0", (Object)selector);
        MethodDescriptor descriptor = this.newDescriptor(selector, ReflectiveDynamic.getArgTypes(args));
        Method method = this.getMethod(descriptor);
        if (method != null) {
            return this.invoke(method, args);
        }
        throw new MessageNotUnderstoodException(descriptor);
    }

    @Override
    public Dynamic chainingSend(String selector, Object ... args) {
        Method method = this.getMethod(this.newDescriptor(selector, ReflectiveDynamic.getArgTypes(args)));
        if (method != null) {
            return Dynamics.nullSafeFrom(this.invoke(method, args));
        }
        return Dynamics.null_();
    }

    @Override
    public Object value() {
        return this.target;
    }

    private Method getMethod(MethodDescriptor key) {
        Method method = CACHE.get(key);
        if (method != null) {
            return method;
        }
        method = this.findMethod(key.getSelector(), key.getArgTypes());
        if (method == null) {
            return null;
        }
        CACHE.put(key, method);
        return method;
    }

    private MethodDescriptor newDescriptor(String selector, Class<?> ... argTypes) {
        MethodDescriptor key = new MethodDescriptor(this.target.getClass(), selector, argTypes);
        return key;
    }

    private Method findMethod(String selector, Class<?>[] argsTypes) {
        Class<?> c = this.target.getClass();
        while (c != null) {
            Method[] methodArray = c.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (ReflectiveDynamic.isDesiredMethod(selector, m, argsTypes)) {
                    return m;
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private static boolean isDesiredMethod(String selector, Method method, Class<?>[] argTypes) {
        return Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == argTypes.length && method.getName().equals(selector) && ReflectiveDynamic.argTypesMatch(argTypes, method.getParameterTypes());
    }

    private static boolean argTypesMatch(Class<?>[] passedArgTypes, Class<?>[] actualArgTypes) {
        int i = 0;
        while (i < passedArgTypes.length) {
            Class<?> actual = actualArgTypes[i];
            Class<?> passed = passedArgTypes[i];
            if (!actual.isAssignableFrom(passed) && !PrimitiveWrappers.isPrimitiveWrapperFor(actual, passed)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Class<?>[] getArgTypes(Object[] args) {
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return parameterTypes;
    }

    private <T> T invoke(Method method, Object ... args) {
        try {
            return (T)method.invoke(this.target, args);
        }
        catch (IllegalAccessException e) {
            throw new MethodEvaluationException(e);
        }
        catch (InvocationTargetException e) {
            throw new MethodEvaluationException(e.getCause());
        }
    }
}

