/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.dynamic;

import java.lang.reflect.Method;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.dynamic.Dynamic;
import net.sf.staccatocommons.dynamic.internal.PrimitiveWrappers;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.exception.ProxyFactoryException;
import org.apache.commons.proxy.factory.javassist.JavassistProxyFactory;
import org.apache.commons.proxy.invoker.NullInvoker;

public abstract class AbstractDynamic
implements Dynamic {
    protected static final JavassistProxyFactory PROXY_FACTORY = new JavassistProxyFactory();
    protected static final NullInvoker NULL_INVOKER = new NullInvoker();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @Override
    public final Dynamic $(String selector, Object ... args) {
        return this.chainingSend(selector, args);
    }

    @Override
    @NonNull
    @ForceRestrictions
    public final <T> Thunk<T> delayedSend(final @NonNull String selector, final Object ... args) {
        Ensure.isNotNull((String)"var1", (Object)args);
        Ensure.isNotNull((String)"var0", (Object)selector);
        return new Thunk<T>(){

            public T value() {
                return AbstractDynamic.this.send(selector, args);
            }
        };
    }

    @Override
    @NonNull
    @ForceRestrictions
    public final <T> T as(@NonNull Class<T> clazz) {
        Ensure.isNotNull((String)"var0", clazz);
        if (this.valueIsInstanceOf(clazz)) {
            return (T)this.value();
        }
        return this.cast(clazz, this.getInvoker());
    }

    @Override
    @NonNull
    @ForceRestrictions
    public final <T> T chainingAs(@NonNull Class<T> clazz) {
        Ensure.isNotNull((String)"var0", clazz);
        if (this.valueIsInstanceOf(clazz)) {
            return (T)this.value();
        }
        return this.cast(clazz, this.getDynamicInvoker());
    }

    private <T> T cast(Class<T> clazz, Invoker invoker) {
        return (T)PROXY_FACTORY.createInvokerProxy(invoker, new Class[]{clazz});
    }

    protected boolean valueIsInstanceOf(Class<?> clazz) {
        return clazz.isAssignableFrom(this.value().getClass()) || PrimitiveWrappers.isPrimitiveWrapperFor(clazz, this.value().getClass());
    }

    protected Invoker getInvoker() {
        return new Invoker(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = AbstractDynamic.this.send(method.getName(), args != null ? args : EMPTY_ARRAY);
                return result != null ? result : NULL_INVOKER.invoke(proxy, method, args);
            }
        };
    }

    private Invoker getDynamicInvoker() {
        return new Invoker(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return AbstractDynamic.this.chainingSend(method.getName(), args != null ? args : EMPTY_ARRAY).chainingAs(method.getReturnType());
                }
                catch (ProxyFactoryException proxyFactoryException) {
                    return NULL_INVOKER.invoke(proxy, method, args);
                }
            }
        };
    }
}

