/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlparam.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AskParamValueDialog
extends DialogWidget {
    private static final long serialVersionUID = 3470927611018381204L;
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(AskParamValueDialog.class);
    private OkClosePanel btnsPnl = new OkClosePanel();
    private JTextField value = new JTextField();
    private JCheckBox quote = new JCheckBox();
    private String parameter = null;
    private String oldValue = null;
    private boolean done = false;
    private boolean cancelled = false;

    public AskParamValueDialog(String parameter, String oldValue, IApplication application) {
        super(stringMgr.getString("sqlparam.inputParameterValues"), true, application);
        this.parameter = parameter;
        this.oldValue = oldValue;
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(), "Center");
        this.setContentPane(content);
        this.btnsPnl.makeOKButtonDefault();
        this.btnsPnl.getRootPane().setDefaultButton(this.btnsPnl.getOKButton());
        this.pack();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setValue(String defaultValue) {
        this.value.setText(defaultValue);
    }

    public String getValue() {
        return this.value.getText();
    }

    public boolean isQuotingNeeded() {
        return this.quote.isSelected();
    }

    private void updateCheckbox() {
        boolean isNumber = false;
        try {
            Float.parseFloat(this.value.getText());
            isNumber = true;
        }
        catch (NumberFormatException nfe) {
            isNumber = false;
        }
        if (isNumber) {
            this.quote.setSelected(false);
            this.quote.setEnabled(true);
        } else {
            this.quote.setSelected(true);
            this.quote.setEnabled(false);
        }
    }

    private Component createMainPanel() {
        this.value.setColumns(20);
        this.value.setText(this.oldValue);
        this.value.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AskParamValueDialog.this.updateCheckbox();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AskParamValueDialog.this.updateCheckbox();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AskParamValueDialog.this.updateCheckbox();
            }
        });
        this.updateCheckbox();
        this.btnsPnl.addListener((IOkClosePanelListener)new MyOkClosePanelListener());
        FormLayout layout = new FormLayout("right:pref, 8dlu, left:min(100dlu;pref):grow", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        int y = 1;
        builder.addSeparator(this.getTitle(), cc.xywh(1, y, 3, 1));
        builder.addLabel(stringMgr.getString("sqlparam.valueFor", new Object[]{this.parameter}), cc.xy(1, y += 2));
        builder.add((Component)this.value, cc.xywh(3, y, 1, 1));
        builder.addLabel(stringMgr.getString("sqlparam.quoteValues"), cc.xy(1, y += 2));
        builder.add((Component)this.quote, cc.xywh(3, y, 1, 1));
        builder.addSeparator("", cc.xywh(1, y += 2, 3, 1));
        builder.add((Component)this.btnsPnl, cc.xywh(1, y += 2, 3, 1));
        return builder.getPanel();
    }

    public void cancel() {
        this.done = true;
        this.cancelled = true;
        this.dispose();
    }

    public void ok() {
        this.done = true;
        this.dispose();
    }

    private final class MyOkClosePanelListener
    implements IOkClosePanelListener {
        private MyOkClosePanelListener() {
        }

        public void okPressed(OkClosePanelEvent evt) {
            AskParamValueDialog.this.ok();
        }

        public void closePressed(OkClosePanelEvent evt) {
            AskParamValueDialog.this.cancel();
        }

        public void cancelPressed(OkClosePanelEvent evt) {
            AskParamValueDialog.this.cancel();
        }
    }
}

