/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff.prefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PreferenceUtil;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.dbdiff.prefs.DBDiffPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dbdiff.prefs.IPluginPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dbdiff.prefs.IPluginPreferencesManager;

public class DefaultPluginPreferencesManager
implements IPluginPreferencesManager {
    private static final ILogger s_log = LoggerController.createLogger(DefaultPluginPreferencesManager.class);
    private final String USER_PREFS_FILE_NAME = "prefs.xml";
    protected FileWrapper _userSettingsFolder;
    protected IPluginPreferenceBean _prefs = null;
    protected IPlugin plugin = null;
    protected Class<? extends IPluginPreferenceBean> preferenceBeanClass = null;

    @Override
    public void initialize(IPlugin thePlugin, Class<? extends IPluginPreferenceBean> preferenceBeanClass) throws PluginException {
        this.plugin = thePlugin;
        this.preferenceBeanClass = preferenceBeanClass;
        try {
            this._userSettingsFolder = this.plugin.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this.loadPrefs();
    }

    @Override
    public IPluginPreferenceBean getPreferences() {
        return this._prefs;
    }

    @Override
    public void unload() {
        this.savePrefs();
    }

    @Override
    public void savePrefs() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter((Object)this._prefs);
            wtr.save(new File(this._userSettingsFolder.getAbsolutePath(), "prefs.xml"));
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured writing to preferences file: prefs.xml", (Throwable)ex);
        }
    }

    private void loadPrefs() {
        FileWrapper prefFile = null;
        try {
            XMLBeanReader doc = new XMLBeanReader();
            prefFile = PreferenceUtil.getPreferenceFileToReadFrom((IPlugin)this.plugin);
            doc.load(prefFile, this.preferenceBeanClass.getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                this._prefs = (DBDiffPreferenceBean)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            s_log.info((Object)("prefs.xml(" + prefFile.getAbsolutePath() + ") not found - will be created"));
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured reading from preferences file: prefs.xml", (Throwable)ex);
        }
        if (this._prefs == null) {
            this._prefs = new DBDiffPreferenceBean();
        }
        this._prefs.setClientName(Version.getApplicationName() + "/" + this.plugin.getDescriptiveName());
        this._prefs.setClientVersion(Version.getShortVersion() + "/" + this.plugin.getVersion());
    }
}

