/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.filter;

import com.jme3.terrain.noise.ShaderUtils;
import com.jme3.terrain.noise.filter.AbstractFilter;
import com.jme3.terrain.noise.fractal.FractalSum;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

public class PerturbFilter
extends AbstractFilter {
    private float magnitude;

    public int getMargin(int size, int margin) {
        margin = super.getMargin(size, margin);
        return (int)Math.floor(this.magnitude * (float)(margin + size) + (float)margin);
    }

    public void setMagnitude(float magnitude) {
        this.magnitude = magnitude;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public FloatBuffer filter(float sx, float sy, float base, FloatBuffer data, int workSize) {
        float[] arr = data.array();
        int origSize = (int)Math.ceil((float)workSize / (2.0f * this.magnitude + 1.0f));
        int offset = (workSize - origSize) / 2;
        Logger.getLogger(PerturbFilter.class.getCanonicalName()).info("Found origSize : " + origSize + " and offset: " + offset + " for workSize : " + workSize + " and magnitude : " + this.magnitude);
        float[] retval = new float[workSize * workSize];
        float[] perturbx = new FractalSum().setOctaves(8.0f).setScale(5.0f).getBuffer(sx, sy, base, workSize).array();
        float[] perturby = new FractalSum().setOctaves(8.0f).setScale(5.0f).getBuffer(sx, sy, base + 1.0f, workSize).array();
        for (int y = 0; y < workSize; ++y) {
            for (int x = 0; x < workSize; ++x) {
                float noisex = perturbx[y * workSize + x];
                float noisey = perturby[y * workSize + x];
                int px = (int)((float)origSize * noisex * this.magnitude);
                int py = (int)((float)origSize * noisey * this.magnitude);
                float c00 = arr[this.wrap(y - py, workSize) * workSize + this.wrap(x - px, workSize)];
                float c01 = arr[this.wrap(y - py, workSize) * workSize + this.wrap(x + px, workSize)];
                float c10 = arr[this.wrap(y + py, workSize) * workSize + this.wrap(x - px, workSize)];
                float c11 = arr[this.wrap(y + py, workSize) * workSize + this.wrap(x + px, workSize)];
                float c0 = ShaderUtils.mix(c00, c01, noisex);
                float c1 = ShaderUtils.mix(c10, c11, noisex);
                retval[y * workSize + x] = ShaderUtils.mix(c0, c1, noisey);
            }
        }
        return FloatBuffer.wrap(retval);
    }

    private int wrap(int v, int size) {
        if (v < 0) {
            return v + size - 1;
        }
        if (v >= size) {
            return v - size;
        }
        return v;
    }
}

