/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.math.ColorRGBA;
import com.jme3.terrain.heightmap.AbstractHeightMap;
import com.jme3.terrain.heightmap.ImageHeightmap;
import com.jme3.texture.Image;
import com.jme3.texture.image.ImageRaster;

public class ImageBasedHeightMap
extends AbstractHeightMap
implements ImageHeightmap {
    protected Image colorImage;
    private float backwardsCompScale = 255.0f;

    public void setImage(Image image) {
        this.colorImage = image;
    }

    public ImageBasedHeightMap(Image colorImage) {
        this.colorImage = colorImage;
    }

    public ImageBasedHeightMap(Image colorImage, float heightScale) {
        this.colorImage = colorImage;
        this.heightScale = heightScale;
    }

    public boolean load() {
        return this.load(false, false);
    }

    protected float calculateHeight(float red, float green, float blue) {
        return (float)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
    }

    protected float calculateHeight(ColorRGBA color) {
        return (float)(0.299 * (double)color.r + 0.587 * (double)color.g + 0.114 * (double)color.b);
    }

    protected ImageRaster getImageRaster() {
        return ImageRaster.create((Image)this.colorImage);
    }

    public boolean load(boolean flipX, boolean flipY) {
        int imageHeight;
        int imageWidth = this.colorImage.getWidth();
        if (imageWidth != (imageHeight = this.colorImage.getHeight())) {
            throw new RuntimeException("imageWidth: " + imageWidth + " != imageHeight: " + imageHeight);
        }
        this.size = imageWidth;
        ImageRaster raster = this.getImageRaster();
        this.heightData = new float[imageWidth * imageHeight];
        ColorRGBA colorStore = new ColorRGBA();
        int index = 0;
        if (flipY) {
            for (int h = 0; h < imageHeight; ++h) {
                int w;
                if (flipX) {
                    for (w = imageWidth - 1; w >= 0; --w) {
                        this.heightData[index++] = this.calculateHeight(raster.getPixel(w, h, colorStore)) * this.heightScale * this.backwardsCompScale;
                    }
                    continue;
                }
                for (w = 0; w < imageWidth; ++w) {
                    this.heightData[index++] = this.calculateHeight(raster.getPixel(w, h, colorStore)) * this.heightScale * this.backwardsCompScale;
                }
            }
        } else {
            for (int h = imageHeight - 1; h >= 0; --h) {
                int w;
                if (flipX) {
                    for (w = imageWidth - 1; w >= 0; --w) {
                        this.heightData[index++] = this.calculateHeight(raster.getPixel(w, h, colorStore)) * this.heightScale * this.backwardsCompScale;
                    }
                    continue;
                }
                for (w = 0; w < imageWidth; ++w) {
                    this.heightData[index++] = this.calculateHeight(raster.getPixel(w, h, colorStore)) * this.heightScale * this.backwardsCompScale;
                }
            }
        }
        return true;
    }
}

