/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.math.FastMath;
import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FaultHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(FaultHeightMap.class.getName());
    public static final int FAULTTYPE_STEP = 0;
    public static final int FAULTTYPE_LINEAR = 1;
    public static final int FAULTTYPE_COSINE = 2;
    public static final int FAULTTYPE_SINE = 3;
    public static final int FAULTSHAPE_LINE = 10;
    public static final int FAULTSHAPE_CIRCLE = 11;
    private long seed;
    private int iterations;
    private float minFaultHeight;
    private float maxFaultHeight;
    private float minRange;
    private float maxRange;
    private float minRadius;
    private float maxRadius;
    private int faultType;
    private int faultShape;

    public FaultHeightMap(int size, int iterations, int faultType, int faultShape, float minFaultHeight, float maxFaultHeight, long seed) throws Exception {
        if (size < 0 || iterations < 0) {
            throw new Exception("Size and iterations must be greater than 0!");
        }
        this.size = size;
        this.iterations = iterations;
        this.faultType = faultType;
        this.faultShape = faultShape;
        this.minFaultHeight = minFaultHeight;
        this.maxFaultHeight = maxFaultHeight;
        this.seed = seed;
        this.minRange = minFaultHeight;
        this.maxRange = maxFaultHeight;
        this.minRadius = size / 10;
        this.maxRadius = size / 4;
        this.load();
    }

    public FaultHeightMap(int size, int iterations, float minFaultHeight, float maxFaultHeight) throws Exception {
        this(size, iterations, 0, 10, minFaultHeight, maxFaultHeight, new Random().nextLong());
    }

    public boolean load() {
        int i;
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new float[this.size * this.size];
        float[][] tempBuffer = new float[this.size][this.size];
        Random random = new Random(this.seed);
        for (i = 0; i < this.iterations; ++i) {
            this.addFault(tempBuffer, random);
        }
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.setHeightAtPoint(tempBuffer[i][j], i, j);
            }
        }
        this.normalizeTerrain(NORMALIZE_RANGE);
        logger.log(Level.FINE, "Fault heightmap generated");
        return true;
    }

    protected void addFault(float[][] tempBuffer, Random random) {
        float faultHeight = this.minFaultHeight + random.nextFloat() * (this.maxFaultHeight - this.minFaultHeight);
        float range = this.minRange + random.nextFloat() * (this.maxRange - this.minRange);
        switch (this.faultShape) {
            case 10: {
                this.addLineFault(tempBuffer, random, faultHeight, range);
                break;
            }
            case 11: {
                this.addCircleFault(tempBuffer, random, faultHeight, range);
            }
        }
    }

    protected void addLineFault(float[][] tempBuffer, Random random, float faultHeight, float range) {
        int x1 = random.nextInt(this.size);
        int x2 = random.nextInt(this.size);
        int y1 = random.nextInt(this.size);
        int y2 = random.nextInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            int j = 0;
            while (j < this.size) {
                float dist = (float)((x2 - x1) * (j - y1) - (y2 - y1) * (i - x1)) / FastMath.sqrt((float)(FastMath.sqr((float)(x2 - x1)) + FastMath.sqr((float)(y2 - y1))));
                float[] fArray = tempBuffer[i];
                int n = j++;
                fArray[n] = fArray[n] + this.calcHeight(dist, random, faultHeight, range);
            }
        }
    }

    protected void addCircleFault(float[][] tempBuffer, Random random, float faultHeight, float range) {
        float radius = random.nextFloat() * (this.maxRadius - this.minRadius) + this.minRadius;
        int intRadius = (int)FastMath.floor((float)radius);
        int x = random.nextInt(this.size + 2 * intRadius) - intRadius;
        int y = random.nextInt(this.size + 2 * intRadius) - intRadius;
        for (int i = 0; i < this.size; ++i) {
            int j = 0;
            while (j < this.size) {
                float dist;
                if (i != x || j != y) {
                    int dx = i - x;
                    int dy = j - y;
                    float dmag = FastMath.sqrt((float)(FastMath.sqr((float)dx) + FastMath.sqr((float)dy)));
                    float rx = (float)x + (float)dx / dmag * radius;
                    float ry = (float)y + (float)dy / dmag * radius;
                    dist = FastMath.sign((float)(dmag - radius)) * FastMath.sqrt((float)(FastMath.sqr((float)((float)i - rx)) + FastMath.sqr((float)((float)j - ry))));
                } else {
                    dist = 0.0f;
                }
                float[] fArray = tempBuffer[i];
                int n = j++;
                fArray[n] = fArray[n] + this.calcHeight(dist, random, faultHeight, range);
            }
        }
    }

    protected float calcHeight(float dist, Random random, float faultHeight, float range) {
        switch (this.faultType) {
            case 0: {
                return FastMath.sign((float)dist) * faultHeight;
            }
            case 1: {
                if (FastMath.abs((float)dist) > range) {
                    return FastMath.sign((float)dist) * faultHeight;
                }
                float f = FastMath.abs((float)dist) / range;
                return FastMath.sign((float)dist) * faultHeight * f;
            }
            case 3: {
                if (FastMath.abs((float)dist) > range) {
                    return -faultHeight;
                }
                float f = dist / range;
                return FastMath.sin((float)((1.0f + 2.0f * f) * (float)Math.PI / 2.0f)) * faultHeight;
            }
            case 2: {
                if (FastMath.abs((float)dist) > range) {
                    return -FastMath.sign((float)dist) * faultHeight;
                }
                float f = dist / range;
                float val = FastMath.cos((float)((1.0f + f) * (float)Math.PI / 2.0f)) * faultHeight;
                return val;
            }
        }
        throw new RuntimeException("Code needs update to switch allcases");
    }

    public int getFaultShape() {
        return this.faultShape;
    }

    public void setFaultShape(int faultShape) {
        this.faultShape = faultShape;
    }

    public int getFaultType() {
        return this.faultType;
    }

    public void setFaultType(int faultType) {
        this.faultType = faultType;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public float getMaxFaultHeight() {
        return this.maxFaultHeight;
    }

    public void setMaxFaultHeight(float maxFaultHeight) {
        this.maxFaultHeight = maxFaultHeight;
    }

    public float getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(float maxRadius) {
        this.maxRadius = maxRadius;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(float maxRange) {
        this.maxRange = maxRange;
    }

    public float getMinFaultHeight() {
        return this.minFaultHeight;
    }

    public void setMinFaultHeight(float minFaultHeight) {
        this.minFaultHeight = minFaultHeight;
    }

    public float getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(float minRadius) {
        this.minRadius = minRadius;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public void setMinRange(float minRange) {
        this.minRange = minRange;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }
}

