/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.terrain.heightmap.HeightMap;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHeightMap
implements HeightMap {
    private static final Logger logger = Logger.getLogger(AbstractHeightMap.class.getName());
    protected float[] heightData = null;
    protected int size = 0;
    protected float heightScale = 1.0f;
    protected float filter = 0.5f;
    public static float NORMALIZE_RANGE = 255.0f;

    public void unloadHeightMap() {
        this.heightData = null;
    }

    public void setHeightScale(float scale) {
        this.heightScale = scale;
    }

    public void setHeightAtPoint(float height, int x, int z) {
        this.heightData[x + z * this.size] = height;
    }

    public void setSize(int size) throws Exception {
        if (size <= 0) {
            throw new Exception("size must be greater than zero.");
        }
        this.size = size;
    }

    public void setMagnificationFilter(float filter) throws Exception {
        if (filter < 0.0f || filter >= 1.0f) {
            throw new Exception("filter must be between 0 and 1");
        }
        this.filter = filter;
    }

    public float getTrueHeightAtPoint(int x, int z) {
        return this.heightData[x + z * this.size];
    }

    public float getScaledHeightAtPoint(int x, int z) {
        return this.heightData[x + z * this.size] * this.heightScale;
    }

    public float getInterpolatedHeight(float x, float z) {
        float low = this.getScaledHeightAtPoint((int)x, (int)z);
        if (x + 1.0f >= (float)this.size) {
            return low;
        }
        float highX = this.getScaledHeightAtPoint((int)x + 1, (int)z);
        float interpolation = x - (float)((int)x);
        float intX = (highX - low) * interpolation + low;
        if (z + 1.0f >= (float)this.size) {
            return low;
        }
        float highZ = this.getScaledHeightAtPoint((int)x, (int)z + 1);
        interpolation = z - (float)((int)z);
        float intZ = (highZ - low) * interpolation + low;
        return (intX + intZ) / 2.0f;
    }

    public float[] getHeightMap() {
        return this.heightData;
    }

    public float[] getScaledHeightMap() {
        float[] hm = new float[this.heightData.length];
        for (int i = 0; i < this.heightData.length; ++i) {
            hm[i] = this.heightScale * this.heightData[i];
        }
        return hm;
    }

    public int getSize() {
        return this.size;
    }

    public boolean save(String filename) throws Exception {
        if (null == filename) {
            throw new Exception("Filename must not be null");
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            DataOutputStream dos = new DataOutputStream(fos);
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    dos.write((int)this.heightData[j + i * this.size]);
                }
            }
            fos.close();
            dos.close();
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "Error opening file {0}", filename);
            return false;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error writing to file {0}", filename);
            return false;
        }
        logger.log(Level.FINE, "Saved terrain to {0}", filename);
        return true;
    }

    public void normalizeTerrain(float value) {
        int j;
        int i;
        float currentMin = this.heightData[0];
        float currentMax = this.heightData[0];
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                if (this.heightData[i + j * this.size] > currentMax) {
                    currentMax = this.heightData[i + j * this.size];
                    continue;
                }
                if (!(this.heightData[i + j * this.size] < currentMin)) continue;
                currentMin = this.heightData[i + j * this.size];
            }
        }
        if (currentMax <= currentMin) {
            return;
        }
        float height = currentMax - currentMin;
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                this.heightData[i + j * this.size] = (this.heightData[i + j * this.size] - currentMin) / height * value;
            }
        }
    }

    public float[] findMinMaxHeights() {
        float[] minmax = new float[2];
        float currentMin = this.heightData[0];
        float currentMax = this.heightData[0];
        for (int i = 0; i < this.heightData.length; ++i) {
            if (this.heightData[i] > currentMax) {
                currentMax = this.heightData[i];
                continue;
            }
            if (!(this.heightData[i] < currentMin)) continue;
            currentMin = this.heightData[i];
        }
        minmax[0] = currentMin;
        minmax[1] = currentMax;
        return minmax;
    }

    public void erodeTerrain() {
        int j;
        float v;
        int i;
        for (i = 0; i < this.size; ++i) {
            v = this.heightData[i];
            for (j = 1; j < this.size; ++j) {
                this.heightData[i + j * this.size] = this.filter * v + (1.0f - this.filter) * this.heightData[i + j * this.size];
                v = this.heightData[i + j * this.size];
            }
        }
        for (i = this.size - 1; i >= 0; --i) {
            v = this.heightData[i];
            for (j = 0; j < this.size; ++j) {
                this.heightData[i + j * this.size] = this.filter * v + (1.0f - this.filter) * this.heightData[i + j * this.size];
                v = this.heightData[i + j * this.size];
            }
        }
        for (i = 0; i < this.size; ++i) {
            v = this.heightData[i];
            for (j = 0; j < this.size; ++j) {
                this.heightData[i + j * this.size] = this.filter * v + (1.0f - this.filter) * this.heightData[i + j * this.size];
                v = this.heightData[i + j * this.size];
            }
        }
        for (i = this.size - 1; i >= 0; --i) {
            v = this.heightData[i];
            for (j = 0; j < this.size; ++j) {
                this.heightData[i + j * this.size] = this.filter * v + (1.0f - this.filter) * this.heightData[i + j * this.size];
                v = this.heightData[i + j * this.size];
            }
        }
    }

    public void flatten(byte flattening) {
        if (flattening <= 1) {
            return;
        }
        float[] minmax = this.findMinMaxHeights();
        this.normalizeTerrain(1.0f);
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                float flat = 1.0f;
                float original = this.heightData[x + y * this.size];
                for (int i = 0; i < flattening; ++i) {
                    flat *= original;
                }
                this.heightData[x + y * this.size] = flat;
            }
        }
        float height = minmax[1] - minmax[0];
        this.normalizeTerrain(height);
    }

    public void smooth(float np) {
        this.smooth(np, 1);
    }

    public void smooth(float np, int radius) {
        if (np < 0.0f || np > 1.0f) {
            return;
        }
        if (radius == 0) {
            radius = 1;
        }
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                int neighNumber = 0;
                float neighAverage = 0.0f;
                for (int rx = -radius; rx <= radius; ++rx) {
                    for (int ry = -radius; ry <= radius; ++ry) {
                        if (x + rx < 0 || x + rx >= this.size || y + ry < 0 || y + ry >= this.size) continue;
                        ++neighNumber;
                        neighAverage += this.heightData[x + rx + (y + ry) * this.size];
                    }
                }
                float cp = 1.0f - np;
                this.heightData[x + y * this.size] = (neighAverage /= (float)neighNumber) * np + this.heightData[x + y * this.size] * cp;
            }
        }
    }
}

