/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.DistanceLodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculatorFactory;
import com.jme3.terrain.geomipmap.lodcalc.LodThreshold;
import java.io.IOException;

public class LodDistanceCalculatorFactory
implements LodCalculatorFactory {
    private float lodThresholdSize = 2.7f;
    private LodThreshold lodThreshold = null;

    public LodDistanceCalculatorFactory() {
    }

    public LodDistanceCalculatorFactory(LodThreshold lodThreshold) {
        this.lodThreshold = lodThreshold;
    }

    public LodCalculator createCalculator() {
        return new DistanceLodCalculator();
    }

    public LodCalculator createCalculator(TerrainPatch terrainPatch) {
        return new DistanceLodCalculator();
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule c = ex.getCapsule((Savable)this);
        c.write((Savable)this.lodThreshold, "lodThreshold", null);
        c.write(this.lodThresholdSize, "lodThresholdSize", 2.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule c = im.getCapsule((Savable)this);
        this.lodThresholdSize = c.readFloat("lodThresholdSize", 2.0f);
        this.lodThreshold = (LodThreshold)c.readSavable("lodThreshold", null);
    }

    public LodDistanceCalculatorFactory clone() {
        LodDistanceCalculatorFactory clone = new LodDistanceCalculatorFactory();
        clone.lodThreshold = this.lodThreshold.clone();
        clone.lodThresholdSize = this.lodThresholdSize;
        return clone;
    }
}

