/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.grid;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.terrain.geomipmap.TerrainGridTileLoader;
import com.jme3.terrain.geomipmap.TerrainQuad;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AssetTileLoader
implements TerrainGridTileLoader {
    private AssetManager manager;
    private String assetPath;
    private String name;
    private int size;
    private int patchSize;
    private int quadSize;

    public AssetTileLoader() {
    }

    public AssetTileLoader(AssetManager manager, String name, String assetPath) {
        this.manager = manager;
        this.name = name;
        this.assetPath = assetPath;
    }

    public TerrainQuad getTerrainQuadAt(Vector3f location) {
        String modelName = this.assetPath + "/" + this.name + "_" + Math.round(location.x) + "_" + Math.round(location.y) + "_" + Math.round(location.z) + ".j3o";
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Load terrain grid tile: {0}", modelName);
        TerrainQuad quad = null;
        try {
            quad = (TerrainQuad)this.manager.loadModel(modelName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (quad == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not load terrain grid tile: {0}", modelName);
            quad = this.createNewQuad(location);
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Loaded terrain grid tile: {0}", modelName);
        }
        return quad;
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public String getName() {
        return this.name;
    }

    public void setPatchSize(int patchSize) {
        this.patchSize = patchSize;
    }

    public void setQuadSize(int quadSize) {
        this.quadSize = quadSize;
    }

    private TerrainQuad createNewQuad(Vector3f location) {
        TerrainQuad q = new TerrainQuad("Quad" + location, this.patchSize, this.quadSize, null);
        return q;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule c = ex.getCapsule((Savable)this);
        c.write(this.assetPath, "assetPath", null);
        c.write(this.name, "name", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule c = im.getCapsule((Savable)this);
        this.manager = im.getAssetManager();
        this.assetPath = c.readString("assetPath", null);
        this.name = c.readString("name", null);
    }
}

