/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.DistanceLodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTerrainLodControl
extends TerrainLodControl {
    List<TerrainQuad> terrains = new ArrayList<TerrainQuad>();
    private List<TerrainQuad> addedTerrains = new ArrayList<TerrainQuad>();
    private List<TerrainQuad> removedTerrains = new ArrayList<TerrainQuad>();

    public MultiTerrainLodControl(List<Camera> cameras) {
        this.cameras = cameras;
        this.lodCalculator = new DistanceLodCalculator(65, 2.7f);
    }

    public MultiTerrainLodControl(Camera camera) {
        ArrayList<Camera> cams = new ArrayList<Camera>();
        cams.add(camera);
        this.cameras = cams;
        this.lodCalculator = new DistanceLodCalculator(65, 2.7f);
    }

    public void addTerrain(TerrainQuad tq) {
        this.addedTerrains.add(tq);
    }

    public void removeTerrain(TerrainQuad tq) {
        this.removedTerrains.add(tq);
    }

    @Override
    protected TerrainLodControl.UpdateLOD getLodThread(List<Vector3f> locations, LodCalculator lodCalculator) {
        return new UpdateMultiLOD(locations, lodCalculator);
    }

    @Override
    protected void prepareTerrain() {
        if (!this.addedTerrains.isEmpty()) {
            for (TerrainQuad t : this.addedTerrains) {
                if (this.terrains.contains(t)) continue;
                this.terrains.add(t);
            }
            this.addedTerrains.clear();
        }
        if (!this.removedTerrains.isEmpty()) {
            this.terrains.removeAll(this.removedTerrains);
            this.removedTerrains.clear();
        }
        for (TerrainQuad terrain : this.terrains) {
            terrain.cacheTerrainTransforms();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateMultiLOD
    extends TerrainLodControl.UpdateLOD {
        protected UpdateMultiLOD(List<Vector3f> camLocations, LodCalculator lodCalculator) {
            super(MultiTerrainLodControl.this, camLocations, lodCalculator);
        }

        @Override
        public HashMap<String, UpdatedTerrainPatch> call() throws Exception {
            MultiTerrainLodControl.this.setLodCalcRunning(true);
            HashMap<String, UpdatedTerrainPatch> updated = new HashMap<String, UpdatedTerrainPatch>();
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.calculateLod(this.camLocations, updated, this.lodCalculator);
            }
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.findNeighboursLod(updated);
            }
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.fixEdges(updated);
            }
            for (TerrainQuad terrainQuad : MultiTerrainLodControl.this.terrains) {
                terrainQuad.reIndexPages(updated, this.lodCalculator.usesVariableLod());
            }
            MultiTerrainLodControl.this.setLodCalcRunning(false);
            return updated;
        }
    }
}

