/*
 * Decompiled with CFR 0.152.
 */
package statemap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EmptyStackException;
import statemap.AbstractFSMContext;
import statemap.DebugOutputType;
import statemap.State7;
import statemap.StateUndefinedException;
import statemap.TransitionHandle;
import statemap.TransitionUndefinedException;

public abstract class FSMContext7
extends AbstractFSMContext
implements Serializable {
    protected static final int DEFAULT_TRANSITION_ID = 0;
    protected static final String DEFAULT_NAME = "Default";
    protected static final String SYSTEM_DEFAULT = "defaultTransition";
    protected static final String STATE_NAME_FORMAT = "%s_%s";
    protected static final String ENTRY_NAME = "%s_%s__Entry_";
    protected static final String EXIT_NAME = "%s_%s__Exit_";
    protected static final String TRANSITION_NAME_FORMAT = "%s_%s_%s";
    protected static final MethodType NO_ARGS_TYPE = MethodType.methodType(Void.TYPE);
    private static final long serialVersionUID = 459520L;
    protected transient State7 mState;
    protected transient State7 mPreviousState;
    protected transient Deque<State7> mStateStack;

    protected FSMContext7(State7 initState) {
        this.mState = initState;
        this.mPreviousState = null;
        this.mStateStack = null;
    }

    @Override
    protected String previousStateName() {
        return this.mPreviousState == null ? "" : this.mPreviousState.getName();
    }

    protected abstract void executeAction(MethodHandle var1);

    private void readObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        istream.defaultReadObject();
    }

    public boolean isInTransition() {
        return this.mState == null;
    }

    public State7 getState() throws StateUndefinedException {
        if (this.mState == null) {
            throw new StateUndefinedException();
        }
        return this.mState;
    }

    public State7 getPreviousState() {
        return this.mPreviousState;
    }

    public void setState(State7 state) {
        if (this.mDebugOutputType != DebugOutputType.NO_DEBUG_OUTPUT) {
            this.debugOutput("ENTERING STATE  : " + state.getName());
        }
        if (this.mState != null) {
            this.mPreviousState = this.mState;
        }
        this.mState = state;
        this.propertyChange(this.mPreviousState, this.mState);
    }

    public void clearState() {
        this.mPreviousState = this.mState;
        this.mState = null;
    }

    public void pushState(State7 state) {
        if (this.mState == null) {
            throw new NullPointerException();
        }
        if (this.mDebugOutputType != DebugOutputType.NO_DEBUG_OUTPUT) {
            this.mDebugStream.println("PUSH TO STATE   : " + state.getName());
        }
        if (this.mStateStack == null) {
            this.mStateStack = new ArrayDeque<State7>();
        }
        this.mPreviousState = this.mState;
        this.mStateStack.push(this.mState);
        this.mState = state;
        this.propertyChange(this.mPreviousState, this.mState);
    }

    public void popState() throws EmptyStackException {
        if (this.mStateStack == null || this.mStateStack.isEmpty()) {
            this.debugOutput("POPPING ON EMPTY STATE STACK.");
            throw new EmptyStackException();
        }
        if (this.mState != null) {
            this.mPreviousState = this.mState;
        }
        this.mState = this.mStateStack.pop();
        if (this.mStateStack.isEmpty()) {
            this.mStateStack = null;
        }
        if (this.mDebugOutputType != DebugOutputType.NO_DEBUG_OUTPUT) {
            this.mDebugStream.println("POP TO STATE    : " + this.mState.getName());
        }
        this.propertyChange(this.mPreviousState, this.mState);
    }

    public void emptyStateStack() {
        if (this.mStateStack != null) {
            this.mStateStack.clear();
            this.mStateStack = null;
        }
    }

    public void enterStartState() {
        this.enterState();
    }

    protected void defaultTransition() {
        this.debugOutput("TRANSITION      : Default");
        throw new TransitionUndefinedException("State: " + this.stateName() + ", Transition: " + this.getTransition());
    }

    protected String stateName() {
        String previousState = this.mPreviousState != null ? this.mPreviousState.getName() : "(state unknown)";
        return this.mState != null ? this.mState.getName() : previousState;
    }

    protected void enterState() {
        MethodHandle mh = this.mState.enterState();
        if (mh != null) {
            this.executeAction(mh);
        }
    }

    protected void exitState() {
        MethodHandle mh = this.mState.exitState();
        if (mh != null) {
            this.executeAction(mh);
        }
    }

    protected static MethodHandle lookupMethod(MethodHandles.Lookup lookup, Class<?> clazz, String name, MethodType mt) {
        MethodHandle retval = null;
        try {
            retval = lookup.findVirtual(clazz, name, mt);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | SecurityException exception) {
            // empty catch block
        }
        return retval;
    }

    protected static TransitionHandle lookupTransition(MethodHandles.Lookup lookup, Class<?> clazz, String mapName, String stateName, String transName, MethodType methodType) {
        MethodType mt = methodType;
        String mn = String.format(TRANSITION_NAME_FORMAT, mapName, stateName, transName);
        boolean isDefault = false;
        MethodHandle mh = FSMContext7.lookupMethod(lookup, clazz, mn, mt);
        if (mh == null && (mh = FSMContext7.lookupMethod(lookup, clazz, mn = String.format(TRANSITION_NAME_FORMAT, mapName, DEFAULT_NAME, transName), mt)) == null) {
            isDefault = true;
            mt = NO_ARGS_TYPE;
            mn = String.format(TRANSITION_NAME_FORMAT, mapName, stateName, DEFAULT_NAME);
            mh = FSMContext7.lookupMethod(lookup, clazz, mn, mt);
            if (mh == null && (mh = FSMContext7.lookupMethod(lookup, clazz, mn = String.format(TRANSITION_NAME_FORMAT, mapName, DEFAULT_NAME, DEFAULT_NAME), mt)) == null) {
                mh = FSMContext7.lookupMethod(lookup, clazz, SYSTEM_DEFAULT, mt);
            }
        }
        return new TransitionHandle(isDefault, mh);
    }
}

