/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public abstract class SmcElement {
    public static final String NIL_STATE = "nil";
    public static final String DEFAULT_STATE = "DefaultState";
    public static final String DEFAULT_TRANSITION = "Default";
    protected final String mName;
    protected final int mLineNumber;

    protected SmcElement(String name, int lineNumber) {
        this.mName = name;
        this.mLineNumber = lineNumber;
    }

    public abstract void accept(SmcVisitor var1);

    public String getName() {
        return this.mName;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public static List<SmcTransition> merge(List<SmcTransition> l1, List<SmcTransition> l2, Comparator<SmcTransition> c) {
        ArrayList<SmcTransition> retval;
        block10: {
            SmcTransition e2;
            Iterator<SmcTransition> it2;
            block9: {
                retval = new ArrayList<SmcTransition>();
                Collections.sort(l1, c);
                Collections.sort(l2, c);
                Iterator<SmcTransition> it1 = l1.iterator();
                it2 = l2.iterator();
                SmcTransition e1 = null;
                e2 = null;
                while ((it1.hasNext() || e1 != null) && (it2.hasNext() || e2 != null)) {
                    int result;
                    if (e1 == null) {
                        e1 = it1.next();
                    }
                    if (e2 == null) {
                        e2 = it2.next();
                    }
                    if ((result = c.compare(e1, e2)) < 0) {
                        retval.add(e1);
                        e1 = null;
                        continue;
                    }
                    if (result > 0) {
                        retval.add(e2);
                        e2 = null;
                        continue;
                    }
                    retval.add(e1);
                    e1 = null;
                    e2 = null;
                }
                if (!it1.hasNext() && e1 == null) break block9;
                if (e1 != null) {
                    retval.add(e1);
                }
                while (it1.hasNext()) {
                    retval.add(it1.next());
                }
                break block10;
            }
            if (!it2.hasNext() && e2 == null) break block10;
            if (e2 != null) {
                retval.add(e2);
            }
            while (it2.hasNext()) {
                retval.add(it2.next());
            }
        }
        return retval;
    }

    public static enum TransType {
        TRANS_NOT_SET,
        TRANS_SET,
        TRANS_PUSH,
        TRANS_POP;

    }
}

